@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelOneArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the hierarchy level.
 * @property id The identifier of the hierarchy level.
 * @property name The name of the user hierarchy level. Must not be more than 50 characters.
 */
public data class UserHierarchyStructureHierarchyStructureLevelOneArgs(
    public val arn: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelOneArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelOneArgs =
        com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelOneArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserHierarchyStructureHierarchyStructureLevelOneArgs].
 */
@PulumiTagMarker
public class UserHierarchyStructureHierarchyStructureLevelOneArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the hierarchy level.
     */
    @JvmName("enombbrsaakristr")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value The identifier of the hierarchy level.
     */
    @JvmName("yqwfbtgfuqdheayi")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the user hierarchy level. Must not be more than 50 characters.
     */
    @JvmName("thqbgrkbsgebsoim")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the hierarchy level.
     */
    @JvmName("unricpboymnqfpnu")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value The identifier of the hierarchy level.
     */
    @JvmName("ornggybjnfundtbc")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the user hierarchy level. Must not be more than 50 characters.
     */
    @JvmName("ecoqljmkiyoucrhp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): UserHierarchyStructureHierarchyStructureLevelOneArgs =
        UserHierarchyStructureHierarchyStructureLevelOneArgs(
            arn = arn,
            id = id,
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
