@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.UserPhoneConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property afterContactWorkTimeLimit The After Call Work (ACW) timeout setting, in seconds. Minimum value of 0.
 * @property autoAccept When Auto-Accept Call is enabled for an available agent, the agent connects to contacts automatically.
 * @property deskPhoneNumber The phone number for the user's desk phone. Required if `phone_type` is set as `DESK_PHONE`.
 * @property phoneType The phone type. Valid values are `DESK_PHONE` and `SOFT_PHONE`.
 */
public data class UserPhoneConfigArgs(
    public val afterContactWorkTimeLimit: Output<Int>? = null,
    public val autoAccept: Output<Boolean>? = null,
    public val deskPhoneNumber: Output<String>? = null,
    public val phoneType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.UserPhoneConfigArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.UserPhoneConfigArgs =
        com.pulumi.aws.connect.inputs.UserPhoneConfigArgs.builder()
            .afterContactWorkTimeLimit(afterContactWorkTimeLimit?.applyValue({ args0 -> args0 }))
            .autoAccept(autoAccept?.applyValue({ args0 -> args0 }))
            .deskPhoneNumber(deskPhoneNumber?.applyValue({ args0 -> args0 }))
            .phoneType(phoneType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPhoneConfigArgs].
 */
@PulumiTagMarker
public class UserPhoneConfigArgsBuilder internal constructor() {
    private var afterContactWorkTimeLimit: Output<Int>? = null

    private var autoAccept: Output<Boolean>? = null

    private var deskPhoneNumber: Output<String>? = null

    private var phoneType: Output<String>? = null

    /**
     * @param value The After Call Work (ACW) timeout setting, in seconds. Minimum value of 0.
     */
    @JvmName("yqskuvfwsciccivh")
    public suspend fun afterContactWorkTimeLimit(`value`: Output<Int>) {
        this.afterContactWorkTimeLimit = value
    }

    /**
     * @param value When Auto-Accept Call is enabled for an available agent, the agent connects to contacts automatically.
     */
    @JvmName("nloajvscqqdbpxpr")
    public suspend fun autoAccept(`value`: Output<Boolean>) {
        this.autoAccept = value
    }

    /**
     * @param value The phone number for the user's desk phone. Required if `phone_type` is set as `DESK_PHONE`.
     */
    @JvmName("nwgodnnnegtnipkw")
    public suspend fun deskPhoneNumber(`value`: Output<String>) {
        this.deskPhoneNumber = value
    }

    /**
     * @param value The phone type. Valid values are `DESK_PHONE` and `SOFT_PHONE`.
     */
    @JvmName("oxrtqmpjfwfpshnx")
    public suspend fun phoneType(`value`: Output<String>) {
        this.phoneType = value
    }

    /**
     * @param value The After Call Work (ACW) timeout setting, in seconds. Minimum value of 0.
     */
    @JvmName("olfsqbflyeqsplbb")
    public suspend fun afterContactWorkTimeLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.afterContactWorkTimeLimit = mapped
    }

    /**
     * @param value When Auto-Accept Call is enabled for an available agent, the agent connects to contacts automatically.
     */
    @JvmName("ioiwadcfdwsvvxpo")
    public suspend fun autoAccept(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAccept = mapped
    }

    /**
     * @param value The phone number for the user's desk phone. Required if `phone_type` is set as `DESK_PHONE`.
     */
    @JvmName("ivlfjjrpvgxrcfkq")
    public suspend fun deskPhoneNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deskPhoneNumber = mapped
    }

    /**
     * @param value The phone type. Valid values are `DESK_PHONE` and `SOFT_PHONE`.
     */
    @JvmName("ujdninokccnyqvjo")
    public suspend fun phoneType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.phoneType = mapped
    }

    internal fun build(): UserPhoneConfigArgs = UserPhoneConfigArgs(
        afterContactWorkTimeLimit = afterContactWorkTimeLimit,
        autoAccept = autoAccept,
        deskPhoneNumber = deskPhoneNumber,
        phoneType = phoneType ?: throw PulumiNullFieldException("phoneType"),
    )
}
