@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getBotAssociation.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId
 * @property lexBot
 */
public data class GetBotAssociationResult(
    public val id: String,
    public val instanceId: String,
    public val lexBot: GetBotAssociationLexBot,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetBotAssociationResult): GetBotAssociationResult = GetBotAssociationResult(
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            lexBot = javaType.lexBot().let({ args0 ->
                com.pulumi.aws.connect.kotlin.outputs.GetBotAssociationLexBot.Companion.toKotlin(args0)
            }),
        )
    }
}
