@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getContactFlow.
 * @property arn ARN of the Contact Flow.
 * @property contactFlowId
 * @property content Logic of the Contact Flow.
 * @property description Description of the Contact Flow.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId
 * @property name
 * @property tags Tags to assign to the Contact Flow.
 * @property type Type of Contact Flow.
 */
public data class GetContactFlowResult(
    public val arn: String,
    public val contactFlowId: String,
    public val content: String,
    public val description: String,
    public val id: String,
    public val instanceId: String,
    public val name: String,
    public val tags: Map<String, String>,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetContactFlowResult): GetContactFlowResult = GetContactFlowResult(
            arn = javaType.arn(),
            contactFlowId = javaType.contactFlowId(),
            content = javaType.content(),
            description = javaType.description(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
