@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property day Day that the hours of operation applies to.
 * @property endTimes End time block specifies the time that your contact center closes. The `end_time` is documented below.
 * @property startTimes Start time block specifies the time that your contact center opens. The `start_time` is documented below.
 */
public data class GetHoursOfOperationConfig(
    public val day: String,
    public val endTimes: List<GetHoursOfOperationConfigEndTime>,
    public val startTimes: List<GetHoursOfOperationConfigStartTime>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetHoursOfOperationConfig): GetHoursOfOperationConfig = GetHoursOfOperationConfig(
            day = javaType.day(),
            endTimes = javaType.endTimes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.GetHoursOfOperationConfigEndTime.Companion.toKotlin(args0)
                })
            }),
            startTimes = javaType.startTimes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.GetHoursOfOperationConfigStartTime.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
