@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceStorageConfig.
 * @property associationId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId
 * @property resourceType
 * @property storageConfigs Specifies the storage configuration options for the Connect Instance. Documented below.
 */
public data class GetInstanceStorageConfigResult(
    public val associationId: String,
    public val id: String,
    public val instanceId: String,
    public val resourceType: String,
    public val storageConfigs: List<GetInstanceStorageConfigStorageConfig>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetInstanceStorageConfigResult): GetInstanceStorageConfigResult = GetInstanceStorageConfigResult(
            associationId = javaType.associationId(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            resourceType = javaType.resourceType(),
            storageConfigs = javaType.storageConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.GetInstanceStorageConfigStorageConfig.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
