@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property kinesisFirehoseConfigs A block that specifies the configuration of the Kinesis Firehose delivery stream. Documented below.
 * @property kinesisStreamConfigs A block that specifies the configuration of the Kinesis data stream. Documented below.
 * @property kinesisVideoStreamConfigs A block that specifies the configuration of the Kinesis video stream. Documented below.
 * @property s3Configs A block that specifies the configuration of S3 Bucket. Documented below.
 * @property storageType A valid storage type. Valid Values: `S3` | `KINESIS_VIDEO_STREAM` | `KINESIS_STREAM` | `KINESIS_FIREHOSE`.
 */
public data class GetInstanceStorageConfigStorageConfig(
    public val kinesisFirehoseConfigs: List<GetInstanceStorageConfigStorageConfigKinesisFirehoseConfig>,
    public val kinesisStreamConfigs: List<GetInstanceStorageConfigStorageConfigKinesisStreamConfig>,
    public val kinesisVideoStreamConfigs: List<GetInstanceStorageConfigStorageConfigKinesisVideoStreamConfig>,
    public val s3Configs: List<GetInstanceStorageConfigStorageConfigS3Config>,
    public val storageType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetInstanceStorageConfigStorageConfig): GetInstanceStorageConfigStorageConfig = GetInstanceStorageConfigStorageConfig(
            kinesisFirehoseConfigs = javaType.kinesisFirehoseConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.GetInstanceStorageConfigStorageConfigKinesisFirehoseConfig.Companion.toKotlin(args0)
                })
            }),
            kinesisStreamConfigs = javaType.kinesisStreamConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.GetInstanceStorageConfigStorageConfigKinesisStreamConfig.Companion.toKotlin(args0)
                })
            }),
            kinesisVideoStreamConfigs = javaType.kinesisVideoStreamConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.GetInstanceStorageConfigStorageConfigKinesisVideoStreamConfig.Companion.toKotlin(args0)
                })
            }),
            s3Configs = javaType.s3Configs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.GetInstanceStorageConfigStorageConfigS3Config.Companion.toKotlin(args0)
                })
            }),
            storageType = javaType.storageType(),
        )
    }
}
