@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property encryptionConfigs The encryption configuration. Documented below.
 * @property prefix The prefix of the video stream. Minimum length of `1`. Maximum length of `128`. When read from the state, the value returned is `<prefix>-connect-<connect_instance_alias>-contact-` since the API appends additional details to the `prefix`.
 * @property retentionPeriodHours The number of hours to retain the data in a data store associated with the stream. Minimum value of `0`. Maximum value of `87600`. A value of `0` indicates that the stream does not persist data.
 */
public data class GetInstanceStorageConfigStorageConfigKinesisVideoStreamConfig(
    public val encryptionConfigs: List<GetInstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfig>,
    public val prefix: String,
    public val retentionPeriodHours: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetInstanceStorageConfigStorageConfigKinesisVideoStreamConfig): GetInstanceStorageConfigStorageConfigKinesisVideoStreamConfig =
            GetInstanceStorageConfigStorageConfigKinesisVideoStreamConfig(
                encryptionConfigs = javaType.encryptionConfigs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.connect.kotlin.outputs.GetInstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfig.Companion.toKotlin(args0)
                    })
                }),
                prefix = javaType.prefix(),
                retentionPeriodHours = javaType.retentionPeriodHours(),
            )
    }
}
