@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bucketName The S3 bucket name.
 * @property bucketPrefix The S3 bucket prefix.
 * @property encryptionConfigs The encryption configuration. Documented below.
 */
public data class GetInstanceStorageConfigStorageConfigS3Config(
    public val bucketName: String,
    public val bucketPrefix: String,
    public val encryptionConfigs: List<GetInstanceStorageConfigStorageConfigS3ConfigEncryptionConfig>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetInstanceStorageConfigStorageConfigS3Config): GetInstanceStorageConfigStorageConfigS3Config =
            GetInstanceStorageConfigStorageConfigS3Config(
                bucketName = javaType.bucketName(),
                bucketPrefix = javaType.bucketPrefix(),
                encryptionConfigs = javaType.encryptionConfigs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.connect.kotlin.outputs.GetInstanceStorageConfigStorageConfigS3ConfigEncryptionConfig.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
