@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getPrompt.
 * @property arn ARN of the Prompt.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId
 * @property name
 * @property promptId Identifier for the prompt.
 */
public data class GetPromptResult(
    public val arn: String,
    public val id: String,
    public val instanceId: String,
    public val name: String,
    public val promptId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetPromptResult): GetPromptResult =
            GetPromptResult(
                arn = javaType.arn(),
                id = javaType.id(),
                instanceId = javaType.instanceId(),
                name = javaType.name(),
                promptId = javaType.promptId(),
            )
    }
}
