@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getQueue.
 * @property arn ARN of the Queue.
 * @property description Description of the Queue.
 * @property hoursOfOperationId Specifies the identifier of the Hours of Operation.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId
 * @property maxContacts Maximum number of contacts that can be in the queue before it is considered full. Minimum value of 0.
 * @property name
 * @property outboundCallerConfigs A block that defines the outbound caller ID name, number, and outbound whisper flow. The Outbound Caller Config block is documented below.
 * @property queueId Identifier for the Queue.
 * @property status Description of the Queue. Values are `ENABLED` or `DISABLED`.
 * @property tags Map of tags assigned to the Queue.
 */
public data class GetQueueResult(
    public val arn: String,
    public val description: String,
    public val hoursOfOperationId: String,
    public val id: String,
    public val instanceId: String,
    public val maxContacts: Int,
    public val name: String,
    public val outboundCallerConfigs: List<GetQueueOutboundCallerConfig>,
    public val queueId: String,
    public val status: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetQueueResult): GetQueueResult =
            GetQueueResult(
                arn = javaType.arn(),
                description = javaType.description(),
                hoursOfOperationId = javaType.hoursOfOperationId(),
                id = javaType.id(),
                instanceId = javaType.instanceId(),
                maxContacts = javaType.maxContacts(),
                name = javaType.name(),
                outboundCallerConfigs = javaType.outboundCallerConfigs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.connect.kotlin.outputs.GetQueueOutboundCallerConfig.Companion.toKotlin(args0)
                    })
                }),
                queueId = javaType.queueId(),
                status = javaType.status(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
