@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getQuickConnect.
 * @property arn ARN of the Quick Connect.
 * @property description Description of the Quick Connect.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId
 * @property name
 * @property quickConnectConfigs A block that defines the configuration information for the Quick Connect: `quick_connect_type` and one of `phone_config`, `queue_config`, `user_config` . The Quick Connect Config block is documented below.
 * @property quickConnectId Identifier for the Quick Connect.
 * @property tags Map of tags to assign to the Quick Connect.
 */
public data class GetQuickConnectResult(
    public val arn: String,
    public val description: String,
    public val id: String,
    public val instanceId: String,
    public val name: String,
    public val quickConnectConfigs: List<GetQuickConnectQuickConnectConfig>,
    public val quickConnectId: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetQuickConnectResult): GetQuickConnectResult = GetQuickConnectResult(
            arn = javaType.arn(),
            description = javaType.description(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            name = javaType.name(),
            quickConnectConfigs = javaType.quickConnectConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.GetQuickConnectQuickConnectConfig.Companion.toKotlin(args0)
                })
            }),
            quickConnectId = javaType.quickConnectId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
