@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property channel Channels agents can handle in the Contact Control Panel (CCP) for this routing profile. Valid values are `VOICE`, `CHAT`, `TASK`.
 * @property delay Delay, in seconds, that a contact should be in the queue before they are routed to an available agent
 * @property priority Order in which contacts are to be handled for the queue.
 * @property queueArn ARN for the queue.
 * @property queueId Identifier for the queue.
 * @property queueName Name for the queue.
 */
public data class GetRoutingProfileQueueConfig(
    public val channel: String,
    public val delay: Int,
    public val priority: Int,
    public val queueArn: String,
    public val queueId: String,
    public val queueName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetRoutingProfileQueueConfig): GetRoutingProfileQueueConfig = GetRoutingProfileQueueConfig(
            channel = javaType.channel(),
            delay = javaType.delay(),
            priority = javaType.priority(),
            queueArn = javaType.queueArn(),
            queueId = javaType.queueId(),
            queueName = javaType.queueName(),
        )
    }
}
