@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property afterContactWorkTimeLimit The After Call Work (ACW) timeout setting, in seconds.
 * @property autoAccept When Auto-Accept Call is enabled for an available agent, the agent connects to contacts automatically.
 * @property deskPhoneNumber The phone number for the user's desk phone.
 * @property phoneType The phone type. Valid values are `DESK_PHONE` and `SOFT_PHONE`.
 */
public data class GetUserPhoneConfig(
    public val afterContactWorkTimeLimit: Int,
    public val autoAccept: Boolean,
    public val deskPhoneNumber: String,
    public val phoneType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetUserPhoneConfig): GetUserPhoneConfig = GetUserPhoneConfig(
            afterContactWorkTimeLimit = javaType.afterContactWorkTimeLimit(),
            autoAccept = javaType.autoAccept(),
            deskPhoneNumber = javaType.deskPhoneNumber(),
            phoneType = javaType.phoneType(),
        )
    }
}
