@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getUser.
 * @property arn The Amazon Resource Name (ARN) of the User.
 * @property directoryUserId The identifier of the user account in the directory used for identity management.
 * @property hierarchyGroupId The identifier of the hierarchy group for the user.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property identityInfos A block that contains information about the identity of the user. Documented below.
 * @property instanceId Specifies the identifier of the hosting Amazon Connect Instance.
 * @property name
 * @property phoneConfigs A block that contains information about the phone settings for the user. Documented below.
 * @property routingProfileId The identifier of the routing profile for the user.
 * @property securityProfileIds A list of identifiers for the security profiles for the user.
 * @property tags A map of tags to assign to the User.
 * @property userId
 */
public data class GetUserResult(
    public val arn: String,
    public val directoryUserId: String,
    public val hierarchyGroupId: String,
    public val id: String,
    public val identityInfos: List<GetUserIdentityInfo>,
    public val instanceId: String,
    public val name: String,
    public val phoneConfigs: List<GetUserPhoneConfig>,
    public val routingProfileId: String,
    public val securityProfileIds: List<String>,
    public val tags: Map<String, String>,
    public val userId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetUserResult): GetUserResult =
            GetUserResult(
                arn = javaType.arn(),
                directoryUserId = javaType.directoryUserId(),
                hierarchyGroupId = javaType.hierarchyGroupId(),
                id = javaType.id(),
                identityInfos = javaType.identityInfos().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.connect.kotlin.outputs.GetUserIdentityInfo.Companion.toKotlin(args0)
                    })
                }),
                instanceId = javaType.instanceId(),
                name = javaType.name(),
                phoneConfigs = javaType.phoneConfigs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.connect.kotlin.outputs.GetUserPhoneConfig.Companion.toKotlin(args0)
                    })
                }),
                routingProfileId = javaType.routingProfileId(),
                securityProfileIds = javaType.securityProfileIds().map({ args0 -> args0 }),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                userId = javaType.userId(),
            )
    }
}
