@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getVocabulary.
 * @property arn The Amazon Resource Name (ARN) of the Vocabulary.
 * @property content The content of the custom vocabulary in plain-text format with a table of values. Each row in the table represents a word or a phrase, described with Phrase, IPA, SoundsLike, and DisplayAs fields. Separate the fields with TAB characters. For more information, see [Create a custom vocabulary using a table](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html#create-vocabulary-table).
 * @property failureReason The reason why the custom vocabulary was not created.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId
 * @property languageCode The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see [What is Amazon Transcribe?](https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html). Valid Values are `ar-AE`, `de-CH`, `de-DE`, `en-AB`, `en-AU`, `en-GB`, `en-IE`, `en-IN`, `en-US`, `en-WL`, `es-ES`, `es-US`, `fr-CA`, `fr-FR`, `hi-IN`, `it-IT`, `ja-JP`, `ko-KR`, `pt-BR`, `pt-PT`, `zh-CN`.
 * @property lastModifiedTime The timestamp when the custom vocabulary was last modified.
 * @property name
 * @property state The current state of the custom vocabulary. Valid values are `CREATION_IN_PROGRESS`, `ACTIVE`, `CREATION_FAILED`, `DELETE_IN_PROGRESS`.
 * @property tags A map of tags to assign to the Vocabulary.
 * @property vocabularyId The identifier of the custom vocabulary.
 */
public data class GetVocabularyResult(
    public val arn: String,
    public val content: String,
    public val failureReason: String,
    public val id: String,
    public val instanceId: String,
    public val languageCode: String,
    public val lastModifiedTime: String,
    public val name: String,
    public val state: String,
    public val tags: Map<String, String>,
    public val vocabularyId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetVocabularyResult): GetVocabularyResult = GetVocabularyResult(
            arn = javaType.arn(),
            content = javaType.content(),
            failureReason = javaType.failureReason(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            languageCode = javaType.languageCode(),
            lastModifiedTime = javaType.lastModifiedTime(),
            name = javaType.name(),
            state = javaType.state(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vocabularyId = javaType.vocabularyId(),
        )
    }
}
