@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kinesisFirehoseConfig A block that specifies the configuration of the Kinesis Firehose delivery stream. Documented below.
 * @property kinesisStreamConfig A block that specifies the configuration of the Kinesis data stream. Documented below.
 * @property kinesisVideoStreamConfig A block that specifies the configuration of the Kinesis video stream. Documented below.
 * @property s3Config A block that specifies the configuration of S3 Bucket. Documented below.
 * @property storageType A valid storage type. Valid Values: `S3` | `KINESIS_VIDEO_STREAM` | `KINESIS_STREAM` | `KINESIS_FIREHOSE`.
 */
public data class InstanceStorageConfigStorageConfig(
    public val kinesisFirehoseConfig: InstanceStorageConfigStorageConfigKinesisFirehoseConfig? = null,
    public val kinesisStreamConfig: InstanceStorageConfigStorageConfigKinesisStreamConfig? = null,
    public val kinesisVideoStreamConfig: InstanceStorageConfigStorageConfigKinesisVideoStreamConfig? =
        null,
    public val s3Config: InstanceStorageConfigStorageConfigS3Config? = null,
    public val storageType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.InstanceStorageConfigStorageConfig): InstanceStorageConfigStorageConfig = InstanceStorageConfigStorageConfig(
            kinesisFirehoseConfig = javaType.kinesisFirehoseConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.InstanceStorageConfigStorageConfigKinesisFirehoseConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kinesisStreamConfig = javaType.kinesisStreamConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.InstanceStorageConfigStorageConfigKinesisStreamConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kinesisVideoStreamConfig = javaType.kinesisVideoStreamConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.InstanceStorageConfigStorageConfigKinesisVideoStreamConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            s3Config = javaType.s3Config().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.InstanceStorageConfigStorageConfigS3Config.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageType = javaType.storageType(),
        )
    }
}
