@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property outboundCallerIdName Specifies the caller ID name.
 * @property outboundCallerIdNumberId Specifies the caller ID number.
 * @property outboundFlowId Specifies outbound whisper flow to be used during an outbound call.
 */
public data class QueueOutboundCallerConfig(
    public val outboundCallerIdName: String? = null,
    public val outboundCallerIdNumberId: String? = null,
    public val outboundFlowId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.QueueOutboundCallerConfig): QueueOutboundCallerConfig = QueueOutboundCallerConfig(
            outboundCallerIdName = javaType.outboundCallerIdName().map({ args0 -> args0 }).orElse(null),
            outboundCallerIdNumberId = javaType.outboundCallerIdNumberId().map({ args0 -> args0 }).orElse(null),
            outboundFlowId = javaType.outboundFlowId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
