@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property channel Specifies the channels agents can handle in the Contact Control Panel (CCP) for this routing profile. Valid values are `VOICE`, `CHAT`, `TASK`.
 * @property delay Specifies the delay, in seconds, that a contact should be in the queue before they are routed to an available agent
 * @property priority Specifies the order in which contacts are to be handled for the queue.
 * @property queueArn ARN for the queue.
 * @property queueId Specifies the identifier for the queue.
 * @property queueName Name for the queue.
 */
public data class RoutingProfileQueueConfig(
    public val channel: String,
    public val delay: Int,
    public val priority: Int,
    public val queueArn: String? = null,
    public val queueId: String,
    public val queueName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.RoutingProfileQueueConfig): RoutingProfileQueueConfig = RoutingProfileQueueConfig(
            channel = javaType.channel(),
            delay = javaType.delay(),
            priority = javaType.priority(),
            queueArn = javaType.queueArn().map({ args0 -> args0 }).orElse(null),
            queueId = javaType.queueId(),
            queueName = javaType.queueName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
