@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the hierarchy group.
 * @property id The identifier of the hierarchy group.
 * @property name The name of the user hierarchy group. Must not be more than 100 characters.
 */
public data class UserHierarchyGroupHierarchyPathLevelOne(
    public val arn: String? = null,
    public val id: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.UserHierarchyGroupHierarchyPathLevelOne): UserHierarchyGroupHierarchyPathLevelOne = UserHierarchyGroupHierarchyPathLevelOne(
            arn = javaType.arn().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
