@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the hierarchy level.
 * @property id The identifier of the hierarchy level.
 * @property name The name of the user hierarchy level. Must not be more than 50 characters.
 */
public data class UserHierarchyStructureHierarchyStructureLevelFour(
    public val arn: String? = null,
    public val id: String? = null,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.UserHierarchyStructureHierarchyStructureLevelFour): UserHierarchyStructureHierarchyStructureLevelFour =
            UserHierarchyStructureHierarchyStructureLevelFour(
                arn = javaType.arn().map({ args0 -> args0 }).orElse(null),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
            )
    }
}
