@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property email The email address. If you are using SAML for identity management and include this parameter, an error is returned. Note that updates to the `email` is supported. From the [UpdateUserIdentityInfo API documentation](https://docs&#46;aws&#46;amazon&#46;com/connect/latest/APIReference/API_UpdateUserIdentityInfo&#46;html) it is strongly recommended to limit who has the ability to invoke `UpdateUserIdentityInfo`&#46; Someone with that ability can change the login credentials of other users by changing their email address&#46; This poses a security risk to your organization&#46; They can change the email address of a user to the attacker's email address, and then reset the password through email&#46; For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the Amazon Connect Administrator Guide.
 * @property firstName The first name. This is required if you are using Amazon Connect or SAML for identity management. Minimum length of 1. Maximum length of 100.
 * @property lastName The last name. This is required if you are using Amazon Connect or SAML for identity management. Minimum length of 1. Maximum length of 100.
 */
public data class UserIdentityInfo(
    public val email: String? = null,
    public val firstName: String? = null,
    public val lastName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.UserIdentityInfo): UserIdentityInfo = UserIdentityInfo(
            email = javaType.email().map({ args0 -> args0 }).orElse(null),
            firstName = javaType.firstName().map({ args0 -> args0 }).orElse(null),
            lastName = javaType.lastName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
