@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.controltower.kotlin

import com.pulumi.aws.controltower.kotlin.outputs.ControlTowerControlParameter
import com.pulumi.aws.controltower.kotlin.outputs.ControlTowerControlParameter.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ControlTowerControl].
 */
@PulumiTagMarker
public class ControlTowerControlResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ControlTowerControlArgs = ControlTowerControlArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ControlTowerControlArgsBuilder.() -> Unit) {
        val builder = ControlTowerControlArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ControlTowerControl {
        val builtJavaResource = com.pulumi.aws.controltower.ControlTowerControl(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ControlTowerControl(builtJavaResource)
    }
}

/**
 * Allows the application of pre-defined controls to organizational units. For more information on usage, please see the
 * [AWS Control Tower User Guide](https://docs.aws.amazon.com/controltower/latest/userguide/enable-guardrails.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getRegion({});
 * const example = aws.organizations.getOrganization({});
 * const exampleGetOrganizationalUnits = example.then(example => aws.organizations.getOrganizationalUnits({
 *     parentId: example.roots?.[0]?.id,
 * }));
 * const exampleControlTowerControl = new aws.controltower.ControlTowerControl("example", {
 *     controlIdentifier: current.then(current => `arn:aws:controltower:${current.name}::control/AWS-GR_EC2_VOLUME_INUSE_CHECK`),
 *     targetIdentifier: exampleGetOrganizationalUnits.then(exampleGetOrganizationalUnits => .filter(x => x.name == "Infrastructure").map(x => (x.arn))[0]),
 *     parameters: [{
 *         key: "AllowedRegions",
 *         value: JSON.stringify(["us-east-1"]),
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * current = aws.get_region()
 * example = aws.organizations.get_organization()
 * example_get_organizational_units = aws.organizations.get_organizational_units(parent_id=example.roots[0].id)
 * example_control_tower_control = aws.controltower.ControlTowerControl("example",
 *     control_identifier=f"arn:aws:controltower:{current.name}::control/AWS-GR_EC2_VOLUME_INUSE_CHECK",
 *     target_identifier=[x&#46;arn for x in example_get_organizational_units&#46;children if x&#46;name == "Infrastructure"][0],
 *     parameters=[{
 *         "key": "AllowedRegions",
 *         "value": json.dumps(["us-east-1"]),
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetRegion.Invoke();
 *     var example = Aws.Organizations.GetOrganization.Invoke();
 *     var exampleGetOrganizationalUnits = Aws.Organizations.GetOrganizationalUnits.Invoke(new()
 *     {
 *         ParentId = example.Apply(getOrganizationResult => getOrganizationResult.Roots[0]?.Id),
 *     });
 *     var exampleControlTowerControl = new Aws.ControlTower.ControlTowerControl("example", new()
 *     {
 *         ControlIdentifier = $"arn:aws:controltower:{current.Apply(getRegionResult => getRegionResult.Name)}::control/AWS-GR_EC2_VOLUME_INUSE_CHECK",
 *         TargetIdentifier = .Where(x => x.Name == "Infrastructure").Select(x =>
 *         {
 *             return x.Arn;
 *         }).ToList()[0],
 *         Parameters = new[]
 *         {
 *             new Aws.ControlTower.Inputs.ControlTowerControlParameterArgs
 *             {
 *                 Key = "AllowedRegions",
 *                 Value = JsonSerializer.Serialize(new[]
 *                 {
 *                     "us-east-1",
 *                 }),
 *             },
 *         },
 *     });
 * });
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Control Tower Controls using their `organizational_unit_arn/control_identifier`. For example:
 * ```sh
 * $ pulumi import aws:controltower/controlTowerControl:ControlTowerControl example arn:aws:organizations::123456789101:ou/o-qqaejywet/ou-qg5o-ufbhdtv3,arn:aws:controltower:us-east-1::control/WTDSMKDKDNLE
 * ```
 */
public class ControlTowerControl internal constructor(
    override val javaResource: com.pulumi.aws.controltower.ControlTowerControl,
) : KotlinCustomResource(javaResource, ControlTowerControlMapper) {
    /**
     * The ARN of the EnabledControl resource.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ARN of the control. Only Strongly recommended and Elective controls are permitted, with the exception of the Region deny guardrail.
     */
    public val controlIdentifier: Output<String>
        get() = javaResource.controlIdentifier().applyValue({ args0 -> args0 })

    /**
     * Parameter values which are specified to configure the control when you enable it. See Parameters for more details.
     */
    public val parameters: Output<List<ControlTowerControlParameter>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The ARN of the organizational unit.
     * The following arguments are optional:
     */
    public val targetIdentifier: Output<String>
        get() = javaResource.targetIdentifier().applyValue({ args0 -> args0 })
}

public object ControlTowerControlMapper : ResourceMapper<ControlTowerControl> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.controltower.ControlTowerControl::class == javaResource::class

    override fun map(javaResource: Resource): ControlTowerControl = ControlTowerControl(
        javaResource
            as com.pulumi.aws.controltower.ControlTowerControl,
    )
}

/**
 * @see [ControlTowerControl].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ControlTowerControl].
 */
public suspend fun controlTowerControl(
    name: String,
    block: suspend ControlTowerControlResourceBuilder.() -> Unit,
): ControlTowerControl {
    val builder = ControlTowerControlResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ControlTowerControl].
 * @param name The _unique_ name of the resulting resource.
 */
public fun controlTowerControl(name: String): ControlTowerControl {
    val builder = ControlTowerControlResourceBuilder()
    builder.name(name)
    return builder.build()
}
