@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.controltower.kotlin

import com.pulumi.aws.controltower.ControltowerFunctions.getControlsPlain
import com.pulumi.aws.controltower.kotlin.inputs.GetControlsPlainArgs
import com.pulumi.aws.controltower.kotlin.inputs.GetControlsPlainArgsBuilder
import com.pulumi.aws.controltower.kotlin.outputs.GetControlsResult
import com.pulumi.aws.controltower.kotlin.outputs.GetControlsResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object ControltowerFunctions {
    /**
     * List of Control Tower controls applied to an OU.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const this = aws.organizations.getOrganization({});
     * const thisGetOrganizationalUnits = _this.then(_this => aws.organizations.getOrganizationalUnits({
     *     parentId: _this.roots?.[0]?.id,
     * }));
     * const thisGetControls = thisGetOrganizationalUnits.then(thisGetOrganizationalUnits => aws.controltower.getControls({
     *     targetIdentifier: .filter(x => x.name == "Security").map(x => (x.arn))[0],
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * this = aws.organizations.get_organization()
     * this_get_organizational_units = aws.organizations.get_organizational_units(parent_id=this.roots[0].id)
     * this_get_controls = aws.controltower.get_controls(target_identifier=[x&#46;arn for x in this_get_organizational_units&#46;children if x&#46;name == "Security"][0])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @this = Aws.Organizations.GetOrganization.Invoke();
     *     var thisGetOrganizationalUnits = Aws.Organizations.GetOrganizationalUnits.Invoke(new()
     *     {
     *         ParentId = @this.Apply(getOrganizationResult => getOrganizationResult.Roots[0]?.Id),
     *     });
     *     var thisGetControls = Aws.ControlTower.GetControls.Invoke(new()
     *     {
     *         TargetIdentifier = [0],
     *     });
     * });
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getControls.
     * @return A collection of values returned by getControls.
     */
    public suspend fun getControls(argument: GetControlsPlainArgs): GetControlsResult =
        toKotlin(getControlsPlain(argument.toJava()).await())

    /**
     * @see [getControls].
     * @param targetIdentifier The ARN of the organizational unit.
     * @return A collection of values returned by getControls.
     */
    public suspend fun getControls(targetIdentifier: String): GetControlsResult {
        val argument = GetControlsPlainArgs(
            targetIdentifier = targetIdentifier,
        )
        return toKotlin(getControlsPlain(argument.toJava()).await())
    }

    /**
     * @see [getControls].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;controltower&#46;kotlin&#46;inputs&#46;GetControlsPlainArgs].
     * @return A collection of values returned by getControls.
     */
    public suspend fun getControls(argument: suspend GetControlsPlainArgsBuilder.() -> Unit): GetControlsResult {
        val builder = GetControlsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getControlsPlain(builtArgument.toJava()).await())
    }
}
