@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.controltower.kotlin

import com.pulumi.aws.controltower.kotlin.outputs.LandingZoneDriftStatus
import com.pulumi.aws.controltower.kotlin.outputs.LandingZoneDriftStatus.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [LandingZone].
 */
@PulumiTagMarker
public class LandingZoneResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LandingZoneArgs = LandingZoneArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LandingZoneArgsBuilder.() -> Unit) {
        val builder = LandingZoneArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LandingZone {
        val builtJavaResource = com.pulumi.aws.controltower.LandingZone(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LandingZone(builtJavaResource)
    }
}

/**
 * Creates a new landing zone using Control Tower. For more information on usage, please see the
 * [AWS Control Tower Landing Zone User Guide](https://docs.aws.amazon.com/controltower/latest/userguide/how-control-tower-works.html).
 * ## Import
 * Using `pulumi import`, import a Control Tower Landing Zone using the `id`. For example:
 * ```sh
 * $ pulumi import aws:controltower/landingZone:LandingZone example 1A2B3C4D5E6F7G8H
 * ```
 */
public class LandingZone internal constructor(
    override val javaResource: com.pulumi.aws.controltower.LandingZone,
) : KotlinCustomResource(javaResource, LandingZoneMapper) {
    /**
     * The ARN of the landing zone.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The drift status summary of the landing zone.
     */
    public val driftStatuses: Output<List<LandingZoneDriftStatus>>
        get() = javaResource.driftStatuses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The latest available version of the landing zone.
     */
    public val latestAvailableVersion: Output<String>
        get() = javaResource.latestAvailableVersion().applyValue({ args0 -> args0 })

    /**
     * The manifest JSON file is a text file that describes your AWS resources. For examples, review [Launch your landing zone](https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch).
     */
    public val manifestJson: Output<String>
        get() = javaResource.manifestJson().applyValue({ args0 -> args0 })

    /**
     * Tags to apply to the landing zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the landing zone, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The landing zone version.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object LandingZoneMapper : ResourceMapper<LandingZone> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.controltower.LandingZone::class == javaResource::class

    override fun map(javaResource: Resource): LandingZone = LandingZone(
        javaResource as
            com.pulumi.aws.controltower.LandingZone,
    )
}

/**
 * @see [LandingZone].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LandingZone].
 */
public suspend fun landingZone(name: String, block: suspend LandingZoneResourceBuilder.() -> Unit): LandingZone {
    val builder = LandingZoneResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LandingZone].
 * @param name The _unique_ name of the resulting resource.
 */
public fun landingZone(name: String): LandingZone {
    val builder = LandingZoneResourceBuilder()
    builder.name(name)
    return builder.build()
}
