@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.controltower.kotlin

import com.pulumi.aws.controltower.LandingZoneArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a new landing zone using Control Tower. For more information on usage, please see the
 * [AWS Control Tower Landing Zone User Guide](https://docs.aws.amazon.com/controltower/latest/userguide/how-control-tower-works.html).
 * ## Import
 * Using `pulumi import`, import a Control Tower Landing Zone using the `id`. For example:
 * ```sh
 * $ pulumi import aws:controltower/landingZone:LandingZone example 1A2B3C4D5E6F7G8H
 * ```
 * @property manifestJson The manifest JSON file is a text file that describes your AWS resources. For examples, review [Launch your landing zone](https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch).
 * @property tags Tags to apply to the landing zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property version The landing zone version.
 */
public data class LandingZoneArgs(
    public val manifestJson: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.controltower.LandingZoneArgs> {
    override fun toJava(): com.pulumi.aws.controltower.LandingZoneArgs =
        com.pulumi.aws.controltower.LandingZoneArgs.builder()
            .manifestJson(manifestJson?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LandingZoneArgs].
 */
@PulumiTagMarker
public class LandingZoneArgsBuilder internal constructor() {
    private var manifestJson: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var version: Output<String>? = null

    /**
     * @param value The manifest JSON file is a text file that describes your AWS resources. For examples, review [Launch your landing zone](https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch).
     */
    @JvmName("jxufwqvysoiuphtq")
    public suspend fun manifestJson(`value`: Output<String>) {
        this.manifestJson = value
    }

    /**
     * @param value Tags to apply to the landing zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("flxmnvxkeryhoekr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The landing zone version.
     */
    @JvmName("wxtkyahpshyrsvch")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The manifest JSON file is a text file that describes your AWS resources. For examples, review [Launch your landing zone](https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch).
     */
    @JvmName("iuwapkqtmddlporr")
    public suspend fun manifestJson(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manifestJson = mapped
    }

    /**
     * @param value Tags to apply to the landing zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kkwrenlucdcbjovr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the landing zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ywvnomcwruoplphs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The landing zone version.
     */
    @JvmName("jvocjtlrlbsueouh")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): LandingZoneArgs = LandingZoneArgs(
        manifestJson = manifestJson,
        tags = tags,
        version = version,
    )
}
