@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.controltower.kotlin.inputs

import com.pulumi.aws.controltower.inputs.ControlTowerControlParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key The name of the parameter.
 * @property value The value of the parameter.
 */
public data class ControlTowerControlParameterArgs(
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.controltower.inputs.ControlTowerControlParameterArgs> {
    override fun toJava(): com.pulumi.aws.controltower.inputs.ControlTowerControlParameterArgs =
        com.pulumi.aws.controltower.inputs.ControlTowerControlParameterArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ControlTowerControlParameterArgs].
 */
@PulumiTagMarker
public class ControlTowerControlParameterArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the parameter.
     */
    @JvmName("xviqeauybcmcrnqs")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The value of the parameter.
     */
    @JvmName("uxkhfthfklbmupgt")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the parameter.
     */
    @JvmName("llwdwejepwlstktn")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The value of the parameter.
     */
    @JvmName("bnvufwhlotvnooiq")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ControlTowerControlParameterArgs = ControlTowerControlParameterArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
