@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [AnomalyMonitor].
 */
@PulumiTagMarker
public class AnomalyMonitorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AnomalyMonitorArgs = AnomalyMonitorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AnomalyMonitorArgsBuilder.() -> Unit) {
        val builder = AnomalyMonitorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AnomalyMonitor {
        val builtJavaResource = com.pulumi.aws.costexplorer.AnomalyMonitor(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AnomalyMonitor(builtJavaResource)
    }
}

/**
 * Provides a CE Anomaly Monitor.
 * ## Example Usage
 * There are two main types of a Cost Anomaly Monitor: `DIMENSIONAL` and `CUSTOM`.
 * ### Dimensional Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const serviceMonitor = new aws.costexplorer.AnomalyMonitor("service_monitor", {
 *     name: "AWSServiceMonitor",
 *     monitorType: "DIMENSIONAL",
 *     monitorDimension: "SERVICE",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * service_monitor = aws.costexplorer.AnomalyMonitor("service_monitor",
 *     name="AWSServiceMonitor",
 *     monitor_type="DIMENSIONAL",
 *     monitor_dimension="SERVICE")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceMonitor = new Aws.CostExplorer.AnomalyMonitor("service_monitor", new()
 *     {
 *         Name = "AWSServiceMonitor",
 *         MonitorType = "DIMENSIONAL",
 *         MonitorDimension = "SERVICE",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/costexplorer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costexplorer.NewAnomalyMonitor(ctx, "service_monitor", &costexplorer.AnomalyMonitorArgs{
 * 			Name:             pulumi.String("AWSServiceMonitor"),
 * 			MonitorType:      pulumi.String("DIMENSIONAL"),
 * 			MonitorDimension: pulumi.String("SERVICE"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.costexplorer.AnomalyMonitor;
 * import com.pulumi.aws.costexplorer.AnomalyMonitorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceMonitor = new AnomalyMonitor("serviceMonitor", AnomalyMonitorArgs.builder()
 *             .name("AWSServiceMonitor")
 *             .monitorType("DIMENSIONAL")
 *             .monitorDimension("SERVICE")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   serviceMonitor:
 *     type: aws:costexplorer:AnomalyMonitor
 *     name: service_monitor
 *     properties:
 *       name: AWSServiceMonitor
 *       monitorType: DIMENSIONAL
 *       monitorDimension: SERVICE
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Custom Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.costexplorer.AnomalyMonitor("test", {
 *     name: "AWSCustomAnomalyMonitor",
 *     monitorType: "CUSTOM",
 *     monitorSpecification: JSON.stringify({
 *         And: undefined,
 *         CostCategories: undefined,
 *         Dimensions: undefined,
 *         Not: undefined,
 *         Or: undefined,
 *         Tags: {
 *             Key: "CostCenter",
 *             MatchOptions: undefined,
 *             Values: ["10000"],
 *         },
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * test = aws.costexplorer.AnomalyMonitor("test",
 *     name="AWSCustomAnomalyMonitor",
 *     monitor_type="CUSTOM",
 *     monitor_specification=json.dumps({
 *         "And": None,
 *         "CostCategories": None,
 *         "Dimensions": None,
 *         "Not": None,
 *         "Or": None,
 *         "Tags": {
 *             "Key": "CostCenter",
 *             "MatchOptions": None,
 *             "Values": ["10000"],
 *         },
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.CostExplorer.AnomalyMonitor("test", new()
 *     {
 *         Name = "AWSCustomAnomalyMonitor",
 *         MonitorType = "CUSTOM",
 *         MonitorSpecification = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["And"] = null,
 *             ["CostCategories"] = null,
 *             ["Dimensions"] = null,
 *             ["Not"] = null,
 *             ["Or"] = null,
 *             ["Tags"] = new Dictionary<string, object?>
 *             {
 *                 ["Key"] = "CostCenter",
 *                 ["MatchOptions"] = null,
 *                 ["Values"] = new[]
 *                 {
 *                     "10000",
 *                 },
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/costexplorer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"And":            nil,
 * 			"CostCategories": nil,
 * 			"Dimensions":     nil,
 * 			"Not":            nil,
 * 			"Or":             nil,
 * 			"Tags": map[string]interface{}{
 * 				"Key":          "CostCenter",
 * 				"MatchOptions": nil,
 * 				"Values": []string{
 * 					"10000",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = costexplorer.NewAnomalyMonitor(ctx, "test", &costexplorer.AnomalyMonitorArgs{
 * 			Name:                 pulumi.String("AWSCustomAnomalyMonitor"),
 * 			MonitorType:          pulumi.String("CUSTOM"),
 * 			MonitorSpecification: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.costexplorer.AnomalyMonitor;
 * import com.pulumi.aws.costexplorer.AnomalyMonitorArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AnomalyMonitor("test", AnomalyMonitorArgs.builder()
 *             .name("AWSCustomAnomalyMonitor")
 *             .monitorType("CUSTOM")
 *             .monitorSpecification(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("And", null),
 *                     jsonProperty("CostCategories", null),
 *                     jsonProperty("Dimensions", null),
 *                     jsonProperty("Not", null),
 *                     jsonProperty("Or", null),
 *                     jsonProperty("Tags", jsonObject(
 *                         jsonProperty("Key", "CostCenter"),
 *                         jsonProperty("MatchOptions", null),
 *                         jsonProperty("Values", jsonArray("10000"))
 *                     ))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:costexplorer:AnomalyMonitor
 *     properties:
 *       name: AWSCustomAnomalyMonitor
 *       monitorType: CUSTOM
 *       monitorSpecification:
 *         fn::toJSON:
 *           And: null
 *           CostCategories: null
 *           Dimensions: null
 *           Not: null
 *           Or: null
 *           Tags:
 *             Key: CostCenter
 *             MatchOptions: null
 *             Values:
 *               - '10000'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_ce_anomaly_monitor` using the `id`. For example:
 * ```sh
 * $ pulumi import aws:costexplorer/anomalyMonitor:AnomalyMonitor example costAnomalyMonitorARN
 * ```
 */
public class AnomalyMonitor internal constructor(
    override val javaResource: com.pulumi.aws.costexplorer.AnomalyMonitor,
) : KotlinCustomResource(javaResource, AnomalyMonitorMapper) {
    /**
     * ARN of the anomaly monitor.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The dimensions to evaluate. Valid values: `SERVICE`.
     */
    public val monitorDimension: Output<String>?
        get() = javaResource.monitorDimension().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A valid JSON representation for the [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html) object.
     */
    public val monitorSpecification: Output<String>?
        get() = javaResource.monitorSpecification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The possible type values. Valid values: `DIMENSIONAL` | `CUSTOM`.
     */
    public val monitorType: Output<String>
        get() = javaResource.monitorType().applyValue({ args0 -> args0 })

    /**
     * The name of the monitor.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object AnomalyMonitorMapper : ResourceMapper<AnomalyMonitor> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.costexplorer.AnomalyMonitor::class == javaResource::class

    override fun map(javaResource: Resource): AnomalyMonitor = AnomalyMonitor(
        javaResource as
            com.pulumi.aws.costexplorer.AnomalyMonitor,
    )
}

/**
 * @see [AnomalyMonitor].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AnomalyMonitor].
 */
public suspend fun anomalyMonitor(
    name: String,
    block: suspend AnomalyMonitorResourceBuilder.() -> Unit,
): AnomalyMonitor {
    val builder = AnomalyMonitorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AnomalyMonitor].
 * @param name The _unique_ name of the resulting resource.
 */
public fun anomalyMonitor(name: String): AnomalyMonitor {
    val builder = AnomalyMonitorResourceBuilder()
    builder.name(name)
    return builder.build()
}
