@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin

import com.pulumi.aws.costexplorer.AnomalyMonitorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CE Anomaly Monitor.
 * ## Example Usage
 * There are two main types of a Cost Anomaly Monitor: `DIMENSIONAL` and `CUSTOM`.
 * ### Dimensional Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const serviceMonitor = new aws.costexplorer.AnomalyMonitor("service_monitor", {
 *     name: "AWSServiceMonitor",
 *     monitorType: "DIMENSIONAL",
 *     monitorDimension: "SERVICE",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * service_monitor = aws.costexplorer.AnomalyMonitor("service_monitor",
 *     name="AWSServiceMonitor",
 *     monitor_type="DIMENSIONAL",
 *     monitor_dimension="SERVICE")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceMonitor = new Aws.CostExplorer.AnomalyMonitor("service_monitor", new()
 *     {
 *         Name = "AWSServiceMonitor",
 *         MonitorType = "DIMENSIONAL",
 *         MonitorDimension = "SERVICE",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/costexplorer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costexplorer.NewAnomalyMonitor(ctx, "service_monitor", &costexplorer.AnomalyMonitorArgs{
 * 			Name:             pulumi.String("AWSServiceMonitor"),
 * 			MonitorType:      pulumi.String("DIMENSIONAL"),
 * 			MonitorDimension: pulumi.String("SERVICE"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.costexplorer.AnomalyMonitor;
 * import com.pulumi.aws.costexplorer.AnomalyMonitorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceMonitor = new AnomalyMonitor("serviceMonitor", AnomalyMonitorArgs.builder()
 *             .name("AWSServiceMonitor")
 *             .monitorType("DIMENSIONAL")
 *             .monitorDimension("SERVICE")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   serviceMonitor:
 *     type: aws:costexplorer:AnomalyMonitor
 *     name: service_monitor
 *     properties:
 *       name: AWSServiceMonitor
 *       monitorType: DIMENSIONAL
 *       monitorDimension: SERVICE
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Custom Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.costexplorer.AnomalyMonitor("test", {
 *     name: "AWSCustomAnomalyMonitor",
 *     monitorType: "CUSTOM",
 *     monitorSpecification: JSON.stringify({
 *         And: undefined,
 *         CostCategories: undefined,
 *         Dimensions: undefined,
 *         Not: undefined,
 *         Or: undefined,
 *         Tags: {
 *             Key: "CostCenter",
 *             MatchOptions: undefined,
 *             Values: ["10000"],
 *         },
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * test = aws.costexplorer.AnomalyMonitor("test",
 *     name="AWSCustomAnomalyMonitor",
 *     monitor_type="CUSTOM",
 *     monitor_specification=json.dumps({
 *         "And": None,
 *         "CostCategories": None,
 *         "Dimensions": None,
 *         "Not": None,
 *         "Or": None,
 *         "Tags": {
 *             "Key": "CostCenter",
 *             "MatchOptions": None,
 *             "Values": ["10000"],
 *         },
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.CostExplorer.AnomalyMonitor("test", new()
 *     {
 *         Name = "AWSCustomAnomalyMonitor",
 *         MonitorType = "CUSTOM",
 *         MonitorSpecification = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["And"] = null,
 *             ["CostCategories"] = null,
 *             ["Dimensions"] = null,
 *             ["Not"] = null,
 *             ["Or"] = null,
 *             ["Tags"] = new Dictionary<string, object?>
 *             {
 *                 ["Key"] = "CostCenter",
 *                 ["MatchOptions"] = null,
 *                 ["Values"] = new[]
 *                 {
 *                     "10000",
 *                 },
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/costexplorer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"And":            nil,
 * 			"CostCategories": nil,
 * 			"Dimensions":     nil,
 * 			"Not":            nil,
 * 			"Or":             nil,
 * 			"Tags": map[string]interface{}{
 * 				"Key":          "CostCenter",
 * 				"MatchOptions": nil,
 * 				"Values": []string{
 * 					"10000",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = costexplorer.NewAnomalyMonitor(ctx, "test", &costexplorer.AnomalyMonitorArgs{
 * 			Name:                 pulumi.String("AWSCustomAnomalyMonitor"),
 * 			MonitorType:          pulumi.String("CUSTOM"),
 * 			MonitorSpecification: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.costexplorer.AnomalyMonitor;
 * import com.pulumi.aws.costexplorer.AnomalyMonitorArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AnomalyMonitor("test", AnomalyMonitorArgs.builder()
 *             .name("AWSCustomAnomalyMonitor")
 *             .monitorType("CUSTOM")
 *             .monitorSpecification(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("And", null),
 *                     jsonProperty("CostCategories", null),
 *                     jsonProperty("Dimensions", null),
 *                     jsonProperty("Not", null),
 *                     jsonProperty("Or", null),
 *                     jsonProperty("Tags", jsonObject(
 *                         jsonProperty("Key", "CostCenter"),
 *                         jsonProperty("MatchOptions", null),
 *                         jsonProperty("Values", jsonArray("10000"))
 *                     ))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:costexplorer:AnomalyMonitor
 *     properties:
 *       name: AWSCustomAnomalyMonitor
 *       monitorType: CUSTOM
 *       monitorSpecification:
 *         fn::toJSON:
 *           And: null
 *           CostCategories: null
 *           Dimensions: null
 *           Not: null
 *           Or: null
 *           Tags:
 *             Key: CostCenter
 *             MatchOptions: null
 *             Values:
 *               - '10000'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_ce_anomaly_monitor` using the `id`. For example:
 * ```sh
 * $ pulumi import aws:costexplorer/anomalyMonitor:AnomalyMonitor example costAnomalyMonitorARN
 * ```
 * @property monitorDimension The dimensions to evaluate. Valid values: `SERVICE`.
 * @property monitorSpecification A valid JSON representation for the [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html) object.
 * @property monitorType The possible type values. Valid values: `DIMENSIONAL` | `CUSTOM`.
 * @property name The name of the monitor.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class AnomalyMonitorArgs(
    public val monitorDimension: Output<String>? = null,
    public val monitorSpecification: Output<String>? = null,
    public val monitorType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.AnomalyMonitorArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.AnomalyMonitorArgs =
        com.pulumi.aws.costexplorer.AnomalyMonitorArgs.builder()
            .monitorDimension(monitorDimension?.applyValue({ args0 -> args0 }))
            .monitorSpecification(monitorSpecification?.applyValue({ args0 -> args0 }))
            .monitorType(monitorType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AnomalyMonitorArgs].
 */
@PulumiTagMarker
public class AnomalyMonitorArgsBuilder internal constructor() {
    private var monitorDimension: Output<String>? = null

    private var monitorSpecification: Output<String>? = null

    private var monitorType: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The dimensions to evaluate. Valid values: `SERVICE`.
     */
    @JvmName("tnsynnrmyvsbtipl")
    public suspend fun monitorDimension(`value`: Output<String>) {
        this.monitorDimension = value
    }

    /**
     * @param value A valid JSON representation for the [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html) object.
     */
    @JvmName("qmrsmtwbsvhayoek")
    public suspend fun monitorSpecification(`value`: Output<String>) {
        this.monitorSpecification = value
    }

    /**
     * @param value The possible type values. Valid values: `DIMENSIONAL` | `CUSTOM`.
     */
    @JvmName("mrjhdywkabjphatn")
    public suspend fun monitorType(`value`: Output<String>) {
        this.monitorType = value
    }

    /**
     * @param value The name of the monitor.
     */
    @JvmName("bpjoidcxayggkpvm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ekilawqdwofdhgyu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The dimensions to evaluate. Valid values: `SERVICE`.
     */
    @JvmName("twfmxoshbxoifxdl")
    public suspend fun monitorDimension(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorDimension = mapped
    }

    /**
     * @param value A valid JSON representation for the [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html) object.
     */
    @JvmName("kngvtbjegblkqtla")
    public suspend fun monitorSpecification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorSpecification = mapped
    }

    /**
     * @param value The possible type values. Valid values: `DIMENSIONAL` | `CUSTOM`.
     */
    @JvmName("dmodbvgayfcrchyo")
    public suspend fun monitorType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorType = mapped
    }

    /**
     * @param value The name of the monitor.
     */
    @JvmName("epjtcgkkijnhpndd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gepipdlmlmrrxapm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ndegaeatxhowoqyj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AnomalyMonitorArgs = AnomalyMonitorArgs(
        monitorDimension = monitorDimension,
        monitorSpecification = monitorSpecification,
        monitorType = monitorType,
        name = name,
        tags = tags,
    )
}
