@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin

import com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRule
import com.pulumi.aws.costexplorer.kotlin.outputs.CostCategorySplitChargeRule
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRule.Companion.toKotlin as costCategoryRuleToKotlin
import com.pulumi.aws.costexplorer.kotlin.outputs.CostCategorySplitChargeRule.Companion.toKotlin as costCategorySplitChargeRuleToKotlin

/**
 * Builder for [CostCategory].
 */
@PulumiTagMarker
public class CostCategoryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CostCategoryArgs = CostCategoryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CostCategoryArgsBuilder.() -> Unit) {
        val builder = CostCategoryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CostCategory {
        val builtJavaResource = com.pulumi.aws.costexplorer.CostCategory(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CostCategory(builtJavaResource)
    }
}

/**
 * Provides a CE Cost Category.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.costexplorer.CostCategory("test", {
 *     name: "NAME",
 *     ruleVersion: "CostCategoryExpression.v1",
 *     rules: [
 *         {
 *             value: "production",
 *             rule: {
 *                 dimension: {
 *                     key: "LINKED_ACCOUNT_NAME",
 *                     values: ["-prod"],
 *                     matchOptions: ["ENDS_WITH"],
 *                 },
 *             },
 *         },
 *         {
 *             value: "staging",
 *             rule: {
 *                 dimension: {
 *                     key: "LINKED_ACCOUNT_NAME",
 *                     values: ["-stg"],
 *                     matchOptions: ["ENDS_WITH"],
 *                 },
 *             },
 *         },
 *         {
 *             value: "testing",
 *             rule: {
 *                 dimension: {
 *                     key: "LINKED_ACCOUNT_NAME",
 *                     values: ["-dev"],
 *                     matchOptions: ["ENDS_WITH"],
 *                 },
 *             },
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.costexplorer.CostCategory("test",
 *     name="NAME",
 *     rule_version="CostCategoryExpression.v1",
 *     rules=[
 *         {
 *             "value": "production",
 *             "rule": {
 *                 "dimension": {
 *                     "key": "LINKED_ACCOUNT_NAME",
 *                     "values": ["-prod"],
 *                     "match_options": ["ENDS_WITH"],
 *                 },
 *             },
 *         },
 *         {
 *             "value": "staging",
 *             "rule": {
 *                 "dimension": {
 *                     "key": "LINKED_ACCOUNT_NAME",
 *                     "values": ["-stg"],
 *                     "match_options": ["ENDS_WITH"],
 *                 },
 *             },
 *         },
 *         {
 *             "value": "testing",
 *             "rule": {
 *                 "dimension": {
 *                     "key": "LINKED_ACCOUNT_NAME",
 *                     "values": ["-dev"],
 *                     "match_options": ["ENDS_WITH"],
 *                 },
 *             },
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.CostExplorer.CostCategory("test", new()
 *     {
 *         Name = "NAME",
 *         RuleVersion = "CostCategoryExpression.v1",
 *         Rules = new[]
 *         {
 *             new Aws.CostExplorer.Inputs.CostCategoryRuleArgs
 *             {
 *                 Value = "production",
 *                 Rule = new Aws.CostExplorer.Inputs.CostCategoryRuleRuleArgs
 *                 {
 *                     Dimension = new Aws.CostExplorer.Inputs.CostCategoryRuleRuleDimensionArgs
 *                     {
 *                         Key = "LINKED_ACCOUNT_NAME",
 *                         Values = new[]
 *                         {
 *                             "-prod",
 *                         },
 *                         MatchOptions = new[]
 *                         {
 *                             "ENDS_WITH",
 *                         },
 *                     },
 *                 },
 *             },
 *             new Aws.CostExplorer.Inputs.CostCategoryRuleArgs
 *             {
 *                 Value = "staging",
 *                 Rule = new Aws.CostExplorer.Inputs.CostCategoryRuleRuleArgs
 *                 {
 *                     Dimension = new Aws.CostExplorer.Inputs.CostCategoryRuleRuleDimensionArgs
 *                     {
 *                         Key = "LINKED_ACCOUNT_NAME",
 *                         Values = new[]
 *                         {
 *                             "-stg",
 *                         },
 *                         MatchOptions = new[]
 *                         {
 *                             "ENDS_WITH",
 *                         },
 *                     },
 *                 },
 *             },
 *             new Aws.CostExplorer.Inputs.CostCategoryRuleArgs
 *             {
 *                 Value = "testing",
 *                 Rule = new Aws.CostExplorer.Inputs.CostCategoryRuleRuleArgs
 *                 {
 *                     Dimension = new Aws.CostExplorer.Inputs.CostCategoryRuleRuleDimensionArgs
 *                     {
 *                         Key = "LINKED_ACCOUNT_NAME",
 *                         Values = new[]
 *                         {
 *                             "-dev",
 *                         },
 *                         MatchOptions = new[]
 *                         {
 *                             "ENDS_WITH",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/costexplorer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costexplorer.NewCostCategory(ctx, "test", &costexplorer.CostCategoryArgs{
 * 			Name:        pulumi.String("NAME"),
 * 			RuleVersion: pulumi.String("CostCategoryExpression.v1"),
 * 			Rules: costexplorer.CostCategoryRuleArray{
 * 				&costexplorer.CostCategoryRuleArgs{
 * 					Value: pulumi.String("production"),
 * 					Rule: &costexplorer.CostCategoryRuleRuleArgs{
 * 						Dimension: &costexplorer.CostCategoryRuleRuleDimensionArgs{
 * 							Key: pulumi.String("LINKED_ACCOUNT_NAME"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("-prod"),
 * 							},
 * 							MatchOptions: pulumi.StringArray{
 * 								pulumi.String("ENDS_WITH"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				&costexplorer.CostCategoryRuleArgs{
 * 					Value: pulumi.String("staging"),
 * 					Rule: &costexplorer.CostCategoryRuleRuleArgs{
 * 						Dimension: &costexplorer.CostCategoryRuleRuleDimensionArgs{
 * 							Key: pulumi.String("LINKED_ACCOUNT_NAME"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("-stg"),
 * 							},
 * 							MatchOptions: pulumi.StringArray{
 * 								pulumi.String("ENDS_WITH"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				&costexplorer.CostCategoryRuleArgs{
 * 					Value: pulumi.String("testing"),
 * 					Rule: &costexplorer.CostCategoryRuleRuleArgs{
 * 						Dimension: &costexplorer.CostCategoryRuleRuleDimensionArgs{
 * 							Key: pulumi.String("LINKED_ACCOUNT_NAME"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("-dev"),
 * 							},
 * 							MatchOptions: pulumi.StringArray{
 * 								pulumi.String("ENDS_WITH"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.costexplorer.CostCategory;
 * import com.pulumi.aws.costexplorer.CostCategoryArgs;
 * import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleArgs;
 * import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleArgs;
 * import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleDimensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new CostCategory("test", CostCategoryArgs.builder()
 *             .name("NAME")
 *             .ruleVersion("CostCategoryExpression.v1")
 *             .rules(
 *                 CostCategoryRuleArgs.builder()
 *                     .value("production")
 *                     .rule(CostCategoryRuleRuleArgs.builder()
 *                         .dimension(CostCategoryRuleRuleDimensionArgs.builder()
 *                             .key("LINKED_ACCOUNT_NAME")
 *                             .values("-prod")
 *                             .matchOptions("ENDS_WITH")
 *                             .build())
 *                         .build())
 *                     .build(),
 *                 CostCategoryRuleArgs.builder()
 *                     .value("staging")
 *                     .rule(CostCategoryRuleRuleArgs.builder()
 *                         .dimension(CostCategoryRuleRuleDimensionArgs.builder()
 *                             .key("LINKED_ACCOUNT_NAME")
 *                             .values("-stg")
 *                             .matchOptions("ENDS_WITH")
 *                             .build())
 *                         .build())
 *                     .build(),
 *                 CostCategoryRuleArgs.builder()
 *                     .value("testing")
 *                     .rule(CostCategoryRuleRuleArgs.builder()
 *                         .dimension(CostCategoryRuleRuleDimensionArgs.builder()
 *                             .key("LINKED_ACCOUNT_NAME")
 *                             .values("-dev")
 *                             .matchOptions("ENDS_WITH")
 *                             .build())
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:costexplorer:CostCategory
 *     properties:
 *       name: NAME
 *       ruleVersion: CostCategoryExpression.v1
 *       rules:
 *         - value: production
 *           rule:
 *             dimension:
 *               key: LINKED_ACCOUNT_NAME
 *               values:
 *                 - -prod
 *               matchOptions:
 *                 - ENDS_WITH
 *         - value: staging
 *           rule:
 *             dimension:
 *               key: LINKED_ACCOUNT_NAME
 *               values:
 *                 - -stg
 *               matchOptions:
 *                 - ENDS_WITH
 *         - value: testing
 *           rule:
 *             dimension:
 *               key: LINKED_ACCOUNT_NAME
 *               values:
 *                 - -dev
 *               matchOptions:
 *                 - ENDS_WITH
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_ce_cost_category` using the id. For example:
 * ```sh
 * $ pulumi import aws:costexplorer/costCategory:CostCategory example costCategoryARN
 * ```
 */
public class CostCategory internal constructor(
    override val javaResource: com.pulumi.aws.costexplorer.CostCategory,
) : KotlinCustomResource(javaResource, CostCategoryMapper) {
    /**
     * ARN of the cost category.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Default value for the cost category.
     */
    public val defaultValue: Output<String>?
        get() = javaResource.defaultValue().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Effective end data of your Cost Category.
     */
    public val effectiveEnd: Output<String>
        get() = javaResource.effectiveEnd().applyValue({ args0 -> args0 })

    /**
     * The Cost Category's effective start date. It can only be a billing start date (first day of the month). If the date isn't provided, it's the first day of the current month. Dates can't be before the previous twelve months, or in the future. For example `2022-11-01T00:00:00Z`.
     * The following arguments are optional:
     */
    public val effectiveStart: Output<String>
        get() = javaResource.effectiveStart().applyValue({ args0 -> args0 })

    /**
     * Unique name for the Cost Category.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Rule schema version in this particular Cost Category.
     */
    public val ruleVersion: Output<String>
        get() = javaResource.ruleVersion().applyValue({ args0 -> args0 })

    /**
     * Configuration block for the Cost Category rules used to categorize costs. See below.
     */
    public val rules: Output<List<CostCategoryRule>>
        get() = javaResource.rules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    costCategoryRuleToKotlin(args0)
                })
            })
        })

    /**
     * Configuration block for the split charge rules used to allocate your charges between your Cost Category values. See below.
     */
    public val splitChargeRules: Output<List<CostCategorySplitChargeRule>>?
        get() = javaResource.splitChargeRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        costCategorySplitChargeRuleToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object CostCategoryMapper : ResourceMapper<CostCategory> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.costexplorer.CostCategory::class == javaResource::class

    override fun map(javaResource: Resource): CostCategory = CostCategory(
        javaResource as
            com.pulumi.aws.costexplorer.CostCategory,
    )
}

/**
 * @see [CostCategory].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CostCategory].
 */
public suspend fun costCategory(
    name: String,
    block: suspend CostCategoryResourceBuilder.() -> Unit,
): CostCategory {
    val builder = CostCategoryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CostCategory].
 * @param name The _unique_ name of the resulting resource.
 */
public fun costCategory(name: String): CostCategory {
    val builder = CostCategoryResourceBuilder()
    builder.name(name)
    return builder.build()
}
