@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin

import com.pulumi.aws.costexplorer.CostexplorerFunctions.getCostCategoryPlain
import com.pulumi.aws.costexplorer.CostexplorerFunctions.getTagsPlain
import com.pulumi.aws.costexplorer.kotlin.inputs.GetCostCategoryPlainArgs
import com.pulumi.aws.costexplorer.kotlin.inputs.GetCostCategoryPlainArgsBuilder
import com.pulumi.aws.costexplorer.kotlin.inputs.GetTagsFilter
import com.pulumi.aws.costexplorer.kotlin.inputs.GetTagsPlainArgs
import com.pulumi.aws.costexplorer.kotlin.inputs.GetTagsPlainArgsBuilder
import com.pulumi.aws.costexplorer.kotlin.inputs.GetTagsSortBy
import com.pulumi.aws.costexplorer.kotlin.inputs.GetTagsTimePeriod
import com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryResult
import com.pulumi.aws.costexplorer.kotlin.outputs.GetTagsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryResult.Companion.toKotlin as getCostCategoryResultToKotlin
import com.pulumi.aws.costexplorer.kotlin.outputs.GetTagsResult.Companion.toKotlin as getTagsResultToKotlin

public object CostexplorerFunctions {
    /**
     * Provides details about a specific CostExplorer Cost Category.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.costexplorer.getCostCategory({
     *     costCategoryArn: "costCategoryARN",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.costexplorer.get_cost_category(cost_category_arn="costCategoryARN")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.CostExplorer.GetCostCategory.Invoke(new()
     *     {
     *         CostCategoryArn = "costCategoryARN",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/costexplorer"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := costexplorer.LookupCostCategory(ctx, &costexplorer.LookupCostCategoryArgs{
     * 			CostCategoryArn: "costCategoryARN",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.costexplorer.CostexplorerFunctions;
     * import com.pulumi.aws.costexplorer.inputs.GetCostCategoryArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CostexplorerFunctions.getCostCategory(GetCostCategoryArgs.builder()
     *             .costCategoryArn("costCategoryARN")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:costexplorer:getCostCategory
     *       Arguments:
     *         costCategoryArn: costCategoryARN
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCostCategory.
     * @return A collection of values returned by getCostCategory.
     */
    public suspend fun getCostCategory(argument: GetCostCategoryPlainArgs): GetCostCategoryResult =
        getCostCategoryResultToKotlin(getCostCategoryPlain(argument.toJava()).await())

    /**
     * @see [getCostCategory].
     * @param costCategoryArn Unique name for the Cost Category.
     * @param tags Configuration block for the specific `Tag` to use for `Expression`. See below.
     * @return A collection of values returned by getCostCategory.
     */
    public suspend fun getCostCategory(costCategoryArn: String, tags: Map<String, String>? = null): GetCostCategoryResult {
        val argument = GetCostCategoryPlainArgs(
            costCategoryArn = costCategoryArn,
            tags = tags,
        )
        return getCostCategoryResultToKotlin(getCostCategoryPlain(argument.toJava()).await())
    }

    /**
     * @see [getCostCategory].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;costexplorer&#46;kotlin&#46;inputs&#46;GetCostCategoryPlainArgs].
     * @return A collection of values returned by getCostCategory.
     */
    public suspend fun getCostCategory(argument: suspend GetCostCategoryPlainArgsBuilder.() -> Unit): GetCostCategoryResult {
        val builder = GetCostCategoryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCostCategoryResultToKotlin(getCostCategoryPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides the available cost allocation tag keys and tag values for a specified period.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.costexplorer.getTags({
     *     timePeriod: {
     *         start: "2021-01-01",
     *         end: "2022-12-01",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.costexplorer.get_tags(time_period={
     *     "start": "2021-01-01",
     *     "end": "2022-12-01",
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.CostExplorer.GetTags.Invoke(new()
     *     {
     *         TimePeriod = new Aws.CostExplorer.Inputs.GetTagsTimePeriodInputArgs
     *         {
     *             Start = "2021-01-01",
     *             End = "2022-12-01",
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/costexplorer"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := costexplorer.GetTags(ctx, &costexplorer.GetTagsArgs{
     * 			TimePeriod: costexplorer.GetTagsTimePeriod{
     * 				Start: "2021-01-01",
     * 				End:   "2022-12-01",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.costexplorer.CostexplorerFunctions;
     * import com.pulumi.aws.costexplorer.inputs.GetTagsArgs;
     * import com.pulumi.aws.costexplorer.inputs.GetTagsTimePeriodArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = CostexplorerFunctions.getTags(GetTagsArgs.builder()
     *             .timePeriod(GetTagsTimePeriodArgs.builder()
     *                 .start("2021-01-01")
     *                 .end("2022-12-01")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:costexplorer:getTags
     *       Arguments:
     *         timePeriod:
     *           start: 2021-01-01
     *           end: 2022-12-01
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTags.
     * @return A collection of values returned by getTags.
     */
    public suspend fun getTags(argument: GetTagsPlainArgs): GetTagsResult =
        getTagsResultToKotlin(getTagsPlain(argument.toJava()).await())

    /**
     * @see [getTags].
     * @param filter Configuration block for the `Expression` object used to categorize costs. See `filter` block below for details.
     * @param searchString Value that you want to search for.
     * @param sortBies Configuration block for the value by which you want to sort the data. `sort_by` block below for details.
     * @param tagKey Key of the tag that you want to return values for.
     * @param timePeriod Configuration block for the start and end dates for retrieving the dimension values. See `time_period` block below for details.
     * The following arguments are optional:
     * @return A collection of values returned by getTags.
     */
    public suspend fun getTags(
        filter: GetTagsFilter? = null,
        searchString: String? = null,
        sortBies: List<GetTagsSortBy>? = null,
        tagKey: String? = null,
        timePeriod: GetTagsTimePeriod,
    ): GetTagsResult {
        val argument = GetTagsPlainArgs(
            filter = filter,
            searchString = searchString,
            sortBies = sortBies,
            tagKey = tagKey,
            timePeriod = timePeriod,
        )
        return getTagsResultToKotlin(getTagsPlain(argument.toJava()).await())
    }

    /**
     * @see [getTags].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;costexplorer&#46;kotlin&#46;inputs&#46;GetTagsPlainArgs].
     * @return A collection of values returned by getTags.
     */
    public suspend fun getTags(argument: suspend GetTagsPlainArgsBuilder.() -> Unit): GetTagsResult {
        val builder = GetTagsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTagsResultToKotlin(getTagsPlain(builtArgument.toJava()).await())
    }
}
