@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionSubscriberArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property address The address of the subscriber. If type is `SNS`, this will be the arn of the sns topic. If type is `EMAIL`, this will be the destination email address.
 * @property type The type of subscription. Valid Values: `SNS` | `EMAIL`.
 */
public data class AnomalySubscriptionSubscriberArgs(
    public val address: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionSubscriberArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionSubscriberArgs =
        com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionSubscriberArgs.builder()
            .address(address.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnomalySubscriptionSubscriberArgs].
 */
@PulumiTagMarker
public class AnomalySubscriptionSubscriberArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The address of the subscriber. If type is `SNS`, this will be the arn of the sns topic. If type is `EMAIL`, this will be the destination email address.
     */
    @JvmName("oaypbtaiplckkcvx")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value The type of subscription. Valid Values: `SNS` | `EMAIL`.
     */
    @JvmName("mvratrkmolvmxooc")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The address of the subscriber. If type is `SNS`, this will be the arn of the sns topic. If type is `EMAIL`, this will be the destination email address.
     */
    @JvmName("ibffqaypslfxkvmk")
    public suspend fun address(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param value The type of subscription. Valid Values: `SNS` | `EMAIL`.
     */
    @JvmName("uoupjsqaixrvfxix")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AnomalySubscriptionSubscriberArgs = AnomalySubscriptionSubscriberArgs(
        address = address ?: throw PulumiNullFieldException("address"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
