@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionAndArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property costCategory Configuration block for the filter that's based on  values. See Cost Category below.
 * @property dimension Configuration block for the specific Dimension to use for.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class AnomalySubscriptionThresholdExpressionAndArgs(
    public val costCategory: Output<AnomalySubscriptionThresholdExpressionAndCostCategoryArgs>? =
        null,
    public val dimension: Output<AnomalySubscriptionThresholdExpressionAndDimensionArgs>? = null,
    public val tags: Output<AnomalySubscriptionThresholdExpressionAndTagsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionAndArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionAndArgs =
        com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionAndArgs.builder()
            .costCategory(costCategory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AnomalySubscriptionThresholdExpressionAndArgs].
 */
@PulumiTagMarker
public class AnomalySubscriptionThresholdExpressionAndArgsBuilder internal constructor() {
    private var costCategory: Output<AnomalySubscriptionThresholdExpressionAndCostCategoryArgs>? =
        null

    private var dimension: Output<AnomalySubscriptionThresholdExpressionAndDimensionArgs>? = null

    private var tags: Output<AnomalySubscriptionThresholdExpressionAndTagsArgs>? = null

    /**
     * @param value Configuration block for the filter that's based on  values. See Cost Category below.
     */
    @JvmName("wgsppmvtmipjneap")
    public suspend fun costCategory(`value`: Output<AnomalySubscriptionThresholdExpressionAndCostCategoryArgs>) {
        this.costCategory = value
    }

    /**
     * @param value Configuration block for the specific Dimension to use for.
     */
    @JvmName("rbowfpwmbyeuolyg")
    public suspend fun dimension(`value`: Output<AnomalySubscriptionThresholdExpressionAndDimensionArgs>) {
        this.dimension = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rnrthnncmkboauno")
    public suspend fun tags(`value`: Output<AnomalySubscriptionThresholdExpressionAndTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for the filter that's based on  values. See Cost Category below.
     */
    @JvmName("xdyeqlxvjshtrqug")
    public suspend fun costCategory(`value`: AnomalySubscriptionThresholdExpressionAndCostCategoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on  values. See Cost Category below.
     */
    @JvmName("roeymqwuoxpbbmdg")
    public suspend fun costCategory(argument: suspend AnomalySubscriptionThresholdExpressionAndCostCategoryArgsBuilder.() -> Unit) {
        val toBeMapped =
            AnomalySubscriptionThresholdExpressionAndCostCategoryArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific Dimension to use for.
     */
    @JvmName("oxuqtbamqmrwugal")
    public suspend fun dimension(`value`: AnomalySubscriptionThresholdExpressionAndDimensionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific Dimension to use for.
     */
    @JvmName("tmnxmalcvixxduul")
    public suspend fun dimension(argument: suspend AnomalySubscriptionThresholdExpressionAndDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = AnomalySubscriptionThresholdExpressionAndDimensionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dimension = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mkihihsyianhfsky")
    public suspend fun tags(`value`: AnomalySubscriptionThresholdExpressionAndTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rmtinxojmyoxkkgr")
    public suspend fun tags(argument: suspend AnomalySubscriptionThresholdExpressionAndTagsArgsBuilder.() -> Unit) {
        val toBeMapped = AnomalySubscriptionThresholdExpressionAndTagsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): AnomalySubscriptionThresholdExpressionAndArgs =
        AnomalySubscriptionThresholdExpressionAndArgs(
            costCategory = costCategory,
            dimension = dimension,
            tags = tags,
        )
}
