@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionAndCostCategoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property key Unique name of the Cost Category.
 * @property matchOptions Match options that you can use to filter your results. MatchOptions is only applicable for actions related to cost category. The default values for MatchOptions is `EQUALS` and `CASE_SENSITIVE`. Valid values are: `EQUALS`,  `ABSENT`, `STARTS_WITH`, `ENDS_WITH`, `CONTAINS`, `CASE_SENSITIVE`, `CASE_INSENSITIVE`.
 * @property values Specific value of the Cost Category.
 */
public data class AnomalySubscriptionThresholdExpressionAndCostCategoryArgs(
    public val key: Output<String>? = null,
    public val matchOptions: Output<List<String>>? = null,
    public val values: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionAndCostCategoryArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionAndCostCategoryArgs =
        com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionAndCostCategoryArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .matchOptions(matchOptions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AnomalySubscriptionThresholdExpressionAndCostCategoryArgs].
 */
@PulumiTagMarker
public class AnomalySubscriptionThresholdExpressionAndCostCategoryArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var matchOptions: Output<List<String>>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value Unique name of the Cost Category.
     */
    @JvmName("nrhksiyjalipcvwq")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Match options that you can use to filter your results. MatchOptions is only applicable for actions related to cost category. The default values for MatchOptions is `EQUALS` and `CASE_SENSITIVE`. Valid values are: `EQUALS`,  `ABSENT`, `STARTS_WITH`, `ENDS_WITH`, `CONTAINS`, `CASE_SENSITIVE`, `CASE_INSENSITIVE`.
     */
    @JvmName("xelxuldhpkbjpflr")
    public suspend fun matchOptions(`value`: Output<List<String>>) {
        this.matchOptions = value
    }

    @JvmName("megeypkhcbocscqp")
    public suspend fun matchOptions(vararg values: Output<String>) {
        this.matchOptions = Output.all(values.asList())
    }

    /**
     * @param values Match options that you can use to filter your results. MatchOptions is only applicable for actions related to cost category. The default values for MatchOptions is `EQUALS` and `CASE_SENSITIVE`. Valid values are: `EQUALS`,  `ABSENT`, `STARTS_WITH`, `ENDS_WITH`, `CONTAINS`, `CASE_SENSITIVE`, `CASE_INSENSITIVE`.
     */
    @JvmName("hiwsithdjkhhnjpl")
    public suspend fun matchOptions(values: List<Output<String>>) {
        this.matchOptions = Output.all(values)
    }

    /**
     * @param value Specific value of the Cost Category.
     */
    @JvmName("bfohwcdqtvrltnxf")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("gtgikmwcljxrrpcr")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values Specific value of the Cost Category.
     */
    @JvmName("qlqlqtlwngrnlnqo")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value Unique name of the Cost Category.
     */
    @JvmName("qgbygfgjaaqgvqgl")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Match options that you can use to filter your results. MatchOptions is only applicable for actions related to cost category. The default values for MatchOptions is `EQUALS` and `CASE_SENSITIVE`. Valid values are: `EQUALS`,  `ABSENT`, `STARTS_WITH`, `ENDS_WITH`, `CONTAINS`, `CASE_SENSITIVE`, `CASE_INSENSITIVE`.
     */
    @JvmName("dmevnfjygeuouadu")
    public suspend fun matchOptions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchOptions = mapped
    }

    /**
     * @param values Match options that you can use to filter your results. MatchOptions is only applicable for actions related to cost category. The default values for MatchOptions is `EQUALS` and `CASE_SENSITIVE`. Valid values are: `EQUALS`,  `ABSENT`, `STARTS_WITH`, `ENDS_WITH`, `CONTAINS`, `CASE_SENSITIVE`, `CASE_INSENSITIVE`.
     */
    @JvmName("ktskvrxwqmnvvpfq")
    public suspend fun matchOptions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchOptions = mapped
    }

    /**
     * @param value Specific value of the Cost Category.
     */
    @JvmName("vlsugruobclcreql")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values Specific value of the Cost Category.
     */
    @JvmName("sohmcjwitbwytuxk")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): AnomalySubscriptionThresholdExpressionAndCostCategoryArgs =
        AnomalySubscriptionThresholdExpressionAndCostCategoryArgs(
            key = key,
            matchOptions = matchOptions,
            values = values,
        )
}
