@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property ands Return results that match both Dimension objects.
 * @property costCategory Configuration block for the filter that's based on  values. See Cost Category below.
 * @property dimension Configuration block for the specific Dimension to use for.
 * @property not Return results that match both Dimension object.
 * @property ors Return results that match both Dimension object.
 * @property tags Configuration block for the specific Tag to use for. See Tags below.
 */
public data class AnomalySubscriptionThresholdExpressionArgs(
    public val ands: Output<List<AnomalySubscriptionThresholdExpressionAndArgs>>? = null,
    public val costCategory: Output<AnomalySubscriptionThresholdExpressionCostCategoryArgs>? = null,
    public val dimension: Output<AnomalySubscriptionThresholdExpressionDimensionArgs>? = null,
    public val not: Output<AnomalySubscriptionThresholdExpressionNotArgs>? = null,
    public val ors: Output<List<AnomalySubscriptionThresholdExpressionOrArgs>>? = null,
    public val tags: Output<AnomalySubscriptionThresholdExpressionTagsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionArgs =
        com.pulumi.aws.costexplorer.inputs.AnomalySubscriptionThresholdExpressionArgs.builder()
            .ands(ands?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .costCategory(costCategory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .not(not?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ors(ors?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AnomalySubscriptionThresholdExpressionArgs].
 */
@PulumiTagMarker
public class AnomalySubscriptionThresholdExpressionArgsBuilder internal constructor() {
    private var ands: Output<List<AnomalySubscriptionThresholdExpressionAndArgs>>? = null

    private var costCategory: Output<AnomalySubscriptionThresholdExpressionCostCategoryArgs>? = null

    private var dimension: Output<AnomalySubscriptionThresholdExpressionDimensionArgs>? = null

    private var not: Output<AnomalySubscriptionThresholdExpressionNotArgs>? = null

    private var ors: Output<List<AnomalySubscriptionThresholdExpressionOrArgs>>? = null

    private var tags: Output<AnomalySubscriptionThresholdExpressionTagsArgs>? = null

    /**
     * @param value Return results that match both Dimension objects.
     */
    @JvmName("lekjnlwlnlxghowt")
    public suspend fun ands(`value`: Output<List<AnomalySubscriptionThresholdExpressionAndArgs>>) {
        this.ands = value
    }

    @JvmName("rpvpclyrbxlvtusq")
    public suspend fun ands(vararg values: Output<AnomalySubscriptionThresholdExpressionAndArgs>) {
        this.ands = Output.all(values.asList())
    }

    /**
     * @param values Return results that match both Dimension objects.
     */
    @JvmName("esavfykhxbdbwcoi")
    public suspend fun ands(values: List<Output<AnomalySubscriptionThresholdExpressionAndArgs>>) {
        this.ands = Output.all(values)
    }

    /**
     * @param value Configuration block for the filter that's based on  values. See Cost Category below.
     */
    @JvmName("fareafbssgksyueu")
    public suspend fun costCategory(`value`: Output<AnomalySubscriptionThresholdExpressionCostCategoryArgs>) {
        this.costCategory = value
    }

    /**
     * @param value Configuration block for the specific Dimension to use for.
     */
    @JvmName("cfswtggddoprdwgr")
    public suspend fun dimension(`value`: Output<AnomalySubscriptionThresholdExpressionDimensionArgs>) {
        this.dimension = value
    }

    /**
     * @param value Return results that match both Dimension object.
     */
    @JvmName("uwteltsvixruigml")
    public suspend fun not(`value`: Output<AnomalySubscriptionThresholdExpressionNotArgs>) {
        this.not = value
    }

    /**
     * @param value Return results that match both Dimension object.
     */
    @JvmName("bvcpajggdbqdjxaw")
    public suspend fun ors(`value`: Output<List<AnomalySubscriptionThresholdExpressionOrArgs>>) {
        this.ors = value
    }

    @JvmName("mguuksxrdlrboiis")
    public suspend fun ors(vararg values: Output<AnomalySubscriptionThresholdExpressionOrArgs>) {
        this.ors = Output.all(values.asList())
    }

    /**
     * @param values Return results that match both Dimension object.
     */
    @JvmName("gljehywjkhhgyjnx")
    public suspend fun ors(values: List<Output<AnomalySubscriptionThresholdExpressionOrArgs>>) {
        this.ors = Output.all(values)
    }

    /**
     * @param value Configuration block for the specific Tag to use for. See Tags below.
     */
    @JvmName("nglvdjyjulpffwra")
    public suspend fun tags(`value`: Output<AnomalySubscriptionThresholdExpressionTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value Return results that match both Dimension objects.
     */
    @JvmName("habkfjtvmejjfkhp")
    public suspend fun ands(`value`: List<AnomalySubscriptionThresholdExpressionAndArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ands = mapped
    }

    /**
     * @param argument Return results that match both Dimension objects.
     */
    @JvmName("xoldpcblvtthabmk")
    public suspend fun ands(argument: List<suspend AnomalySubscriptionThresholdExpressionAndArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AnomalySubscriptionThresholdExpressionAndArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param argument Return results that match both Dimension objects.
     */
    @JvmName("uixtnaacjkynsecd")
    public suspend fun ands(vararg argument: suspend AnomalySubscriptionThresholdExpressionAndArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AnomalySubscriptionThresholdExpressionAndArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param argument Return results that match both Dimension objects.
     */
    @JvmName("hijwbfrdjpycadie")
    public suspend fun ands(argument: suspend AnomalySubscriptionThresholdExpressionAndArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AnomalySubscriptionThresholdExpressionAndArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param values Return results that match both Dimension objects.
     */
    @JvmName("sxdypjowkbqjuicd")
    public suspend fun ands(vararg values: AnomalySubscriptionThresholdExpressionAndArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ands = mapped
    }

    /**
     * @param value Configuration block for the filter that's based on  values. See Cost Category below.
     */
    @JvmName("bpgwebsoifbqdrhc")
    public suspend fun costCategory(`value`: AnomalySubscriptionThresholdExpressionCostCategoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on  values. See Cost Category below.
     */
    @JvmName("exgriifmodevytad")
    public suspend fun costCategory(argument: suspend AnomalySubscriptionThresholdExpressionCostCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = AnomalySubscriptionThresholdExpressionCostCategoryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific Dimension to use for.
     */
    @JvmName("xeyxrsrjexkrswhr")
    public suspend fun dimension(`value`: AnomalySubscriptionThresholdExpressionDimensionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific Dimension to use for.
     */
    @JvmName("alxjiybuuaxgfdif")
    public suspend fun dimension(argument: suspend AnomalySubscriptionThresholdExpressionDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = AnomalySubscriptionThresholdExpressionDimensionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dimension = mapped
    }

    /**
     * @param value Return results that match both Dimension object.
     */
    @JvmName("esfpeejotvnaouct")
    public suspend fun not(`value`: AnomalySubscriptionThresholdExpressionNotArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.not = mapped
    }

    /**
     * @param argument Return results that match both Dimension object.
     */
    @JvmName("qicadhtyloplpvng")
    public suspend fun not(argument: suspend AnomalySubscriptionThresholdExpressionNotArgsBuilder.() -> Unit) {
        val toBeMapped = AnomalySubscriptionThresholdExpressionNotArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.not = mapped
    }

    /**
     * @param value Return results that match both Dimension object.
     */
    @JvmName("rknoosbxhygkeagf")
    public suspend fun ors(`value`: List<AnomalySubscriptionThresholdExpressionOrArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ors = mapped
    }

    /**
     * @param argument Return results that match both Dimension object.
     */
    @JvmName("gkjmsvwgnrlmpake")
    public suspend fun ors(argument: List<suspend AnomalySubscriptionThresholdExpressionOrArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AnomalySubscriptionThresholdExpressionOrArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ors = mapped
    }

    /**
     * @param argument Return results that match both Dimension object.
     */
    @JvmName("ladasoyqcawbukkv")
    public suspend fun ors(vararg argument: suspend AnomalySubscriptionThresholdExpressionOrArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AnomalySubscriptionThresholdExpressionOrArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ors = mapped
    }

    /**
     * @param argument Return results that match both Dimension object.
     */
    @JvmName("odepdnulmawcdybv")
    public suspend fun ors(argument: suspend AnomalySubscriptionThresholdExpressionOrArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AnomalySubscriptionThresholdExpressionOrArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ors = mapped
    }

    /**
     * @param values Return results that match both Dimension object.
     */
    @JvmName("ovbuxblorqmciaau")
    public suspend fun ors(vararg values: AnomalySubscriptionThresholdExpressionOrArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ors = mapped
    }

    /**
     * @param value Configuration block for the specific Tag to use for. See Tags below.
     */
    @JvmName("bmlxwsxfyufgoukd")
    public suspend fun tags(`value`: AnomalySubscriptionThresholdExpressionTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Configuration block for the specific Tag to use for. See Tags below.
     */
    @JvmName("gyndxvorpaogkhqv")
    public suspend fun tags(argument: suspend AnomalySubscriptionThresholdExpressionTagsArgsBuilder.() -> Unit) {
        val toBeMapped = AnomalySubscriptionThresholdExpressionTagsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): AnomalySubscriptionThresholdExpressionArgs =
        AnomalySubscriptionThresholdExpressionArgs(
            ands = ands,
            costCategory = costCategory,
            dimension = dimension,
            not = not,
            ors = ors,
            tags = tags,
        )
}
