@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleInheritedValueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dimensionKey Key to extract cost category values.
 * @property dimensionName Name of the dimension that's used to group costs. If you specify `LINKED_ACCOUNT_NAME`, the cost category value is based on account name. If you specify `TAG`, the cost category value will be based on the value of the specified tag key. Valid values are `LINKED_ACCOUNT_NAME`, `TAG`
 */
public data class CostCategoryRuleInheritedValueArgs(
    public val dimensionKey: Output<String>? = null,
    public val dimensionName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.CostCategoryRuleInheritedValueArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.CostCategoryRuleInheritedValueArgs =
        com.pulumi.aws.costexplorer.inputs.CostCategoryRuleInheritedValueArgs.builder()
            .dimensionKey(dimensionKey?.applyValue({ args0 -> args0 }))
            .dimensionName(dimensionName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CostCategoryRuleInheritedValueArgs].
 */
@PulumiTagMarker
public class CostCategoryRuleInheritedValueArgsBuilder internal constructor() {
    private var dimensionKey: Output<String>? = null

    private var dimensionName: Output<String>? = null

    /**
     * @param value Key to extract cost category values.
     */
    @JvmName("xygvkkdckajuhayj")
    public suspend fun dimensionKey(`value`: Output<String>) {
        this.dimensionKey = value
    }

    /**
     * @param value Name of the dimension that's used to group costs. If you specify `LINKED_ACCOUNT_NAME`, the cost category value is based on account name. If you specify `TAG`, the cost category value will be based on the value of the specified tag key. Valid values are `LINKED_ACCOUNT_NAME`, `TAG`
     */
    @JvmName("rjdsbsdyvyeknxmt")
    public suspend fun dimensionName(`value`: Output<String>) {
        this.dimensionName = value
    }

    /**
     * @param value Key to extract cost category values.
     */
    @JvmName("aakusxqclhtobhdi")
    public suspend fun dimensionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensionKey = mapped
    }

    /**
     * @param value Name of the dimension that's used to group costs. If you specify `LINKED_ACCOUNT_NAME`, the cost category value is based on account name. If you specify `TAG`, the cost category value will be based on the value of the specified tag key. Valid values are `LINKED_ACCOUNT_NAME`, `TAG`
     */
    @JvmName("abudejdwccsdapfo")
    public suspend fun dimensionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensionName = mapped
    }

    internal fun build(): CostCategoryRuleInheritedValueArgs = CostCategoryRuleInheritedValueArgs(
        dimensionKey = dimensionKey,
        dimensionName = dimensionName,
    )
}
