@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleAndAndArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CostCategoryRuleRuleAndAndArgs(
    public val costCategory: Output<CostCategoryRuleRuleAndAndCostCategoryArgs>? = null,
    public val dimension: Output<CostCategoryRuleRuleAndAndDimensionArgs>? = null,
    public val tags: Output<CostCategoryRuleRuleAndAndTagsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleAndAndArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleAndAndArgs =
        com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleAndAndArgs.builder()
            .costCategory(costCategory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CostCategoryRuleRuleAndAndArgs].
 */
@PulumiTagMarker
public class CostCategoryRuleRuleAndAndArgsBuilder internal constructor() {
    private var costCategory: Output<CostCategoryRuleRuleAndAndCostCategoryArgs>? = null

    private var dimension: Output<CostCategoryRuleRuleAndAndDimensionArgs>? = null

    private var tags: Output<CostCategoryRuleRuleAndAndTagsArgs>? = null

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("ovvstoocllmxujgb")
    public suspend fun costCategory(`value`: Output<CostCategoryRuleRuleAndAndCostCategoryArgs>) {
        this.costCategory = value
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("lfywbpmxjvghsuhc")
    public suspend fun dimension(`value`: Output<CostCategoryRuleRuleAndAndDimensionArgs>) {
        this.dimension = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fnsrlbmsrfdwgbks")
    public suspend fun tags(`value`: Output<CostCategoryRuleRuleAndAndTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("lhjxdoypskavdeum")
    public suspend fun costCategory(`value`: CostCategoryRuleRuleAndAndCostCategoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("imjpftrciiefescs")
    public suspend fun costCategory(argument: suspend CostCategoryRuleRuleAndAndCostCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleAndAndCostCategoryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("vbrvrhobltfvogje")
    public suspend fun dimension(`value`: CostCategoryRuleRuleAndAndDimensionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("gfjcifydbqrunawg")
    public suspend fun dimension(argument: suspend CostCategoryRuleRuleAndAndDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleAndAndDimensionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dimension = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yavbdofwlmhjwqrr")
    public suspend fun tags(`value`: CostCategoryRuleRuleAndAndTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ieexutpyhakoudcr")
    public suspend fun tags(argument: suspend CostCategoryRuleRuleAndAndTagsArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleAndAndTagsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): CostCategoryRuleRuleAndAndArgs = CostCategoryRuleRuleAndAndArgs(
        costCategory = costCategory,
        dimension = dimension,
        tags = tags,
    )
}
