@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleAndArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property ands Return results that match both `Dimension` objects.
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property not Return results that match both `Dimension` object.
 * @property ors Return results that match both `Dimension` object.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CostCategoryRuleRuleAndArgs(
    public val ands: Output<List<CostCategoryRuleRuleAndAndArgs>>? = null,
    public val costCategory: Output<CostCategoryRuleRuleAndCostCategoryArgs>? = null,
    public val dimension: Output<CostCategoryRuleRuleAndDimensionArgs>? = null,
    public val not: Output<CostCategoryRuleRuleAndNotArgs>? = null,
    public val ors: Output<List<CostCategoryRuleRuleAndOrArgs>>? = null,
    public val tags: Output<CostCategoryRuleRuleAndTagsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleAndArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleAndArgs =
        com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleAndArgs.builder()
            .ands(ands?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .costCategory(costCategory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .not(not?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ors(ors?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CostCategoryRuleRuleAndArgs].
 */
@PulumiTagMarker
public class CostCategoryRuleRuleAndArgsBuilder internal constructor() {
    private var ands: Output<List<CostCategoryRuleRuleAndAndArgs>>? = null

    private var costCategory: Output<CostCategoryRuleRuleAndCostCategoryArgs>? = null

    private var dimension: Output<CostCategoryRuleRuleAndDimensionArgs>? = null

    private var not: Output<CostCategoryRuleRuleAndNotArgs>? = null

    private var ors: Output<List<CostCategoryRuleRuleAndOrArgs>>? = null

    private var tags: Output<CostCategoryRuleRuleAndTagsArgs>? = null

    /**
     * @param value Return results that match both `Dimension` objects.
     */
    @JvmName("jjeyfcyhmnbqcnae")
    public suspend fun ands(`value`: Output<List<CostCategoryRuleRuleAndAndArgs>>) {
        this.ands = value
    }

    @JvmName("wwfnbqqhdxsakmnv")
    public suspend fun ands(vararg values: Output<CostCategoryRuleRuleAndAndArgs>) {
        this.ands = Output.all(values.asList())
    }

    /**
     * @param values Return results that match both `Dimension` objects.
     */
    @JvmName("icpyaskqodaflhgj")
    public suspend fun ands(values: List<Output<CostCategoryRuleRuleAndAndArgs>>) {
        this.ands = Output.all(values)
    }

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("rentiokujxiihnln")
    public suspend fun costCategory(`value`: Output<CostCategoryRuleRuleAndCostCategoryArgs>) {
        this.costCategory = value
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("qyfduapujibcwcqf")
    public suspend fun dimension(`value`: Output<CostCategoryRuleRuleAndDimensionArgs>) {
        this.dimension = value
    }

    /**
     * @param value Return results that match both `Dimension` object.
     */
    @JvmName("oxltlhkpimiikasd")
    public suspend fun not(`value`: Output<CostCategoryRuleRuleAndNotArgs>) {
        this.not = value
    }

    /**
     * @param value Return results that match both `Dimension` object.
     */
    @JvmName("mfpclvnjqimeccmj")
    public suspend fun ors(`value`: Output<List<CostCategoryRuleRuleAndOrArgs>>) {
        this.ors = value
    }

    @JvmName("wfrifncdcloiqanw")
    public suspend fun ors(vararg values: Output<CostCategoryRuleRuleAndOrArgs>) {
        this.ors = Output.all(values.asList())
    }

    /**
     * @param values Return results that match both `Dimension` object.
     */
    @JvmName("yciltwflluwbjern")
    public suspend fun ors(values: List<Output<CostCategoryRuleRuleAndOrArgs>>) {
        this.ors = Output.all(values)
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qujsfdhijfmffyfh")
    public suspend fun tags(`value`: Output<CostCategoryRuleRuleAndTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value Return results that match both `Dimension` objects.
     */
    @JvmName("svojyffvupjfmufc")
    public suspend fun ands(`value`: List<CostCategoryRuleRuleAndAndArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ands = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` objects.
     */
    @JvmName("pcwlerucokaqbkmj")
    public suspend fun ands(argument: List<suspend CostCategoryRuleRuleAndAndArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CostCategoryRuleRuleAndAndArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` objects.
     */
    @JvmName("refnwqmrqaciwcon")
    public suspend fun ands(vararg argument: suspend CostCategoryRuleRuleAndAndArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CostCategoryRuleRuleAndAndArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` objects.
     */
    @JvmName("txjnmobsnkaiyaba")
    public suspend fun ands(argument: suspend CostCategoryRuleRuleAndAndArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CostCategoryRuleRuleAndAndArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param values Return results that match both `Dimension` objects.
     */
    @JvmName("hvtgdhyshchetpuu")
    public suspend fun ands(vararg values: CostCategoryRuleRuleAndAndArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ands = mapped
    }

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("wdxkawndonwyxemb")
    public suspend fun costCategory(`value`: CostCategoryRuleRuleAndCostCategoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("vckkrpabnqyemown")
    public suspend fun costCategory(argument: suspend CostCategoryRuleRuleAndCostCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleAndCostCategoryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("ivmksgcjjdpifrrc")
    public suspend fun dimension(`value`: CostCategoryRuleRuleAndDimensionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("htrgdewklxujwkgn")
    public suspend fun dimension(argument: suspend CostCategoryRuleRuleAndDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleAndDimensionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dimension = mapped
    }

    /**
     * @param value Return results that match both `Dimension` object.
     */
    @JvmName("xkyyesodtaxfevjf")
    public suspend fun not(`value`: CostCategoryRuleRuleAndNotArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.not = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` object.
     */
    @JvmName("vkdawglmacbffoyb")
    public suspend fun not(argument: suspend CostCategoryRuleRuleAndNotArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleAndNotArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.not = mapped
    }

    /**
     * @param value Return results that match both `Dimension` object.
     */
    @JvmName("ywtojtwutbntmrqh")
    public suspend fun ors(`value`: List<CostCategoryRuleRuleAndOrArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ors = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` object.
     */
    @JvmName("lmeojkcokxnqkvuf")
    public suspend fun ors(argument: List<suspend CostCategoryRuleRuleAndOrArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CostCategoryRuleRuleAndOrArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ors = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` object.
     */
    @JvmName("rxuyssldubqsfalb")
    public suspend fun ors(vararg argument: suspend CostCategoryRuleRuleAndOrArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CostCategoryRuleRuleAndOrArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ors = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` object.
     */
    @JvmName("jqtivwoxdnoqhsjs")
    public suspend fun ors(argument: suspend CostCategoryRuleRuleAndOrArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CostCategoryRuleRuleAndOrArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ors = mapped
    }

    /**
     * @param values Return results that match both `Dimension` object.
     */
    @JvmName("bnxagbenbxwiewnt")
    public suspend fun ors(vararg values: CostCategoryRuleRuleAndOrArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ors = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hudmlcfxktolculd")
    public suspend fun tags(`value`: CostCategoryRuleRuleAndTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kelxqjvlgeagxutq")
    public suspend fun tags(argument: suspend CostCategoryRuleRuleAndTagsArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleAndTagsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): CostCategoryRuleRuleAndArgs = CostCategoryRuleRuleAndArgs(
        ands = ands,
        costCategory = costCategory,
        dimension = dimension,
        not = not,
        ors = ors,
        tags = tags,
    )
}
