@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleAndNotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CostCategoryRuleRuleAndNotArgs(
    public val costCategory: Output<CostCategoryRuleRuleAndNotCostCategoryArgs>? = null,
    public val dimension: Output<CostCategoryRuleRuleAndNotDimensionArgs>? = null,
    public val tags: Output<CostCategoryRuleRuleAndNotTagsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleAndNotArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleAndNotArgs =
        com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleAndNotArgs.builder()
            .costCategory(costCategory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CostCategoryRuleRuleAndNotArgs].
 */
@PulumiTagMarker
public class CostCategoryRuleRuleAndNotArgsBuilder internal constructor() {
    private var costCategory: Output<CostCategoryRuleRuleAndNotCostCategoryArgs>? = null

    private var dimension: Output<CostCategoryRuleRuleAndNotDimensionArgs>? = null

    private var tags: Output<CostCategoryRuleRuleAndNotTagsArgs>? = null

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("ajjjsvgprsosmjqk")
    public suspend fun costCategory(`value`: Output<CostCategoryRuleRuleAndNotCostCategoryArgs>) {
        this.costCategory = value
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("jpvdnegnftijmthv")
    public suspend fun dimension(`value`: Output<CostCategoryRuleRuleAndNotDimensionArgs>) {
        this.dimension = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iqikveqaabdvnycy")
    public suspend fun tags(`value`: Output<CostCategoryRuleRuleAndNotTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("elnopdhyahcturxb")
    public suspend fun costCategory(`value`: CostCategoryRuleRuleAndNotCostCategoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("jbuwxmaxfqkvhutd")
    public suspend fun costCategory(argument: suspend CostCategoryRuleRuleAndNotCostCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleAndNotCostCategoryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("ncwglrcgdfudwobp")
    public suspend fun dimension(`value`: CostCategoryRuleRuleAndNotDimensionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("vcaywhjmgxyqvlwy")
    public suspend fun dimension(argument: suspend CostCategoryRuleRuleAndNotDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleAndNotDimensionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dimension = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xnexeyufpfybklia")
    public suspend fun tags(`value`: CostCategoryRuleRuleAndNotTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eiqoulodfdvkufhk")
    public suspend fun tags(argument: suspend CostCategoryRuleRuleAndNotTagsArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleAndNotTagsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): CostCategoryRuleRuleAndNotArgs = CostCategoryRuleRuleAndNotArgs(
        costCategory = costCategory,
        dimension = dimension,
        tags = tags,
    )
}
