@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleAndOrArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CostCategoryRuleRuleAndOrArgs(
    public val costCategory: Output<CostCategoryRuleRuleAndOrCostCategoryArgs>? = null,
    public val dimension: Output<CostCategoryRuleRuleAndOrDimensionArgs>? = null,
    public val tags: Output<CostCategoryRuleRuleAndOrTagsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleAndOrArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleAndOrArgs =
        com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleAndOrArgs.builder()
            .costCategory(costCategory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CostCategoryRuleRuleAndOrArgs].
 */
@PulumiTagMarker
public class CostCategoryRuleRuleAndOrArgsBuilder internal constructor() {
    private var costCategory: Output<CostCategoryRuleRuleAndOrCostCategoryArgs>? = null

    private var dimension: Output<CostCategoryRuleRuleAndOrDimensionArgs>? = null

    private var tags: Output<CostCategoryRuleRuleAndOrTagsArgs>? = null

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("vdocxtpfskgqnarb")
    public suspend fun costCategory(`value`: Output<CostCategoryRuleRuleAndOrCostCategoryArgs>) {
        this.costCategory = value
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("scwudxokncvcxwqc")
    public suspend fun dimension(`value`: Output<CostCategoryRuleRuleAndOrDimensionArgs>) {
        this.dimension = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pultwjdwnxvdgdeh")
    public suspend fun tags(`value`: Output<CostCategoryRuleRuleAndOrTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("mlfehwidcwhxtgig")
    public suspend fun costCategory(`value`: CostCategoryRuleRuleAndOrCostCategoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("jdxxgcwkakfspmik")
    public suspend fun costCategory(argument: suspend CostCategoryRuleRuleAndOrCostCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleAndOrCostCategoryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("edhsljqgpiqifwqd")
    public suspend fun dimension(`value`: CostCategoryRuleRuleAndOrDimensionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("nvicwtfnfxxdgevb")
    public suspend fun dimension(argument: suspend CostCategoryRuleRuleAndOrDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleAndOrDimensionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dimension = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ohtckolpayuinqdx")
    public suspend fun tags(`value`: CostCategoryRuleRuleAndOrTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xasacnawxglndlhu")
    public suspend fun tags(argument: suspend CostCategoryRuleRuleAndOrTagsArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleAndOrTagsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): CostCategoryRuleRuleAndOrArgs = CostCategoryRuleRuleAndOrArgs(
        costCategory = costCategory,
        dimension = dimension,
        tags = tags,
    )
}
