@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotAndArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CostCategoryRuleRuleNotAndArgs(
    public val costCategory: Output<CostCategoryRuleRuleNotAndCostCategoryArgs>? = null,
    public val dimension: Output<CostCategoryRuleRuleNotAndDimensionArgs>? = null,
    public val tags: Output<CostCategoryRuleRuleNotAndTagsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotAndArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotAndArgs =
        com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotAndArgs.builder()
            .costCategory(costCategory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CostCategoryRuleRuleNotAndArgs].
 */
@PulumiTagMarker
public class CostCategoryRuleRuleNotAndArgsBuilder internal constructor() {
    private var costCategory: Output<CostCategoryRuleRuleNotAndCostCategoryArgs>? = null

    private var dimension: Output<CostCategoryRuleRuleNotAndDimensionArgs>? = null

    private var tags: Output<CostCategoryRuleRuleNotAndTagsArgs>? = null

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("pbtiyjqpsabhmmha")
    public suspend fun costCategory(`value`: Output<CostCategoryRuleRuleNotAndCostCategoryArgs>) {
        this.costCategory = value
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("cjevkqtyvbgyqehv")
    public suspend fun dimension(`value`: Output<CostCategoryRuleRuleNotAndDimensionArgs>) {
        this.dimension = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eslcuhmqbcubbipo")
    public suspend fun tags(`value`: Output<CostCategoryRuleRuleNotAndTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("tgnlbkkioxhgmxbb")
    public suspend fun costCategory(`value`: CostCategoryRuleRuleNotAndCostCategoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("vpdxgmpfbepckvel")
    public suspend fun costCategory(argument: suspend CostCategoryRuleRuleNotAndCostCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleNotAndCostCategoryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("wpubaxtoaxafxyng")
    public suspend fun dimension(`value`: CostCategoryRuleRuleNotAndDimensionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("keiromomiqgihvjs")
    public suspend fun dimension(argument: suspend CostCategoryRuleRuleNotAndDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleNotAndDimensionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dimension = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vgktlfprlyulbrds")
    public suspend fun tags(`value`: CostCategoryRuleRuleNotAndTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mhxtvvlkxythoqmx")
    public suspend fun tags(argument: suspend CostCategoryRuleRuleNotAndTagsArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleNotAndTagsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): CostCategoryRuleRuleNotAndArgs = CostCategoryRuleRuleNotAndArgs(
        costCategory = costCategory,
        dimension = dimension,
        tags = tags,
    )
}
