@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property ands Return results that match both `Dimension` objects.
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property not Return results that match both `Dimension` object.
 * @property ors Return results that match both `Dimension` object.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CostCategoryRuleRuleNotArgs(
    public val ands: Output<List<CostCategoryRuleRuleNotAndArgs>>? = null,
    public val costCategory: Output<CostCategoryRuleRuleNotCostCategoryArgs>? = null,
    public val dimension: Output<CostCategoryRuleRuleNotDimensionArgs>? = null,
    public val not: Output<CostCategoryRuleRuleNotNotArgs>? = null,
    public val ors: Output<List<CostCategoryRuleRuleNotOrArgs>>? = null,
    public val tags: Output<CostCategoryRuleRuleNotTagsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotArgs =
        com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotArgs.builder()
            .ands(ands?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .costCategory(costCategory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .not(not?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ors(ors?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CostCategoryRuleRuleNotArgs].
 */
@PulumiTagMarker
public class CostCategoryRuleRuleNotArgsBuilder internal constructor() {
    private var ands: Output<List<CostCategoryRuleRuleNotAndArgs>>? = null

    private var costCategory: Output<CostCategoryRuleRuleNotCostCategoryArgs>? = null

    private var dimension: Output<CostCategoryRuleRuleNotDimensionArgs>? = null

    private var not: Output<CostCategoryRuleRuleNotNotArgs>? = null

    private var ors: Output<List<CostCategoryRuleRuleNotOrArgs>>? = null

    private var tags: Output<CostCategoryRuleRuleNotTagsArgs>? = null

    /**
     * @param value Return results that match both `Dimension` objects.
     */
    @JvmName("gkhoqrmjhfxunjgv")
    public suspend fun ands(`value`: Output<List<CostCategoryRuleRuleNotAndArgs>>) {
        this.ands = value
    }

    @JvmName("euevqimknaprnpgj")
    public suspend fun ands(vararg values: Output<CostCategoryRuleRuleNotAndArgs>) {
        this.ands = Output.all(values.asList())
    }

    /**
     * @param values Return results that match both `Dimension` objects.
     */
    @JvmName("oydglhsmnoxveuty")
    public suspend fun ands(values: List<Output<CostCategoryRuleRuleNotAndArgs>>) {
        this.ands = Output.all(values)
    }

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("aevnkjuejplasiwm")
    public suspend fun costCategory(`value`: Output<CostCategoryRuleRuleNotCostCategoryArgs>) {
        this.costCategory = value
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("yliytkunmpircxtk")
    public suspend fun dimension(`value`: Output<CostCategoryRuleRuleNotDimensionArgs>) {
        this.dimension = value
    }

    /**
     * @param value Return results that match both `Dimension` object.
     */
    @JvmName("pdyujatwgqfgujlj")
    public suspend fun not(`value`: Output<CostCategoryRuleRuleNotNotArgs>) {
        this.not = value
    }

    /**
     * @param value Return results that match both `Dimension` object.
     */
    @JvmName("hpibwpjjhosfudnq")
    public suspend fun ors(`value`: Output<List<CostCategoryRuleRuleNotOrArgs>>) {
        this.ors = value
    }

    @JvmName("mebdlkgjspidukmb")
    public suspend fun ors(vararg values: Output<CostCategoryRuleRuleNotOrArgs>) {
        this.ors = Output.all(values.asList())
    }

    /**
     * @param values Return results that match both `Dimension` object.
     */
    @JvmName("utyytogqaxnftgbl")
    public suspend fun ors(values: List<Output<CostCategoryRuleRuleNotOrArgs>>) {
        this.ors = Output.all(values)
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vuvinlisuybflgjw")
    public suspend fun tags(`value`: Output<CostCategoryRuleRuleNotTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value Return results that match both `Dimension` objects.
     */
    @JvmName("qyxjytgaxrnjcyyc")
    public suspend fun ands(`value`: List<CostCategoryRuleRuleNotAndArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ands = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` objects.
     */
    @JvmName("pvilaxpwbiubcbdu")
    public suspend fun ands(argument: List<suspend CostCategoryRuleRuleNotAndArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CostCategoryRuleRuleNotAndArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` objects.
     */
    @JvmName("rxhglgbswbuqdrul")
    public suspend fun ands(vararg argument: suspend CostCategoryRuleRuleNotAndArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CostCategoryRuleRuleNotAndArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` objects.
     */
    @JvmName("svhamomjdqphsbwi")
    public suspend fun ands(argument: suspend CostCategoryRuleRuleNotAndArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CostCategoryRuleRuleNotAndArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param values Return results that match both `Dimension` objects.
     */
    @JvmName("dvqhofhfrcwnmofw")
    public suspend fun ands(vararg values: CostCategoryRuleRuleNotAndArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ands = mapped
    }

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("iecukrtwlcutture")
    public suspend fun costCategory(`value`: CostCategoryRuleRuleNotCostCategoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("gusbwspedrapspii")
    public suspend fun costCategory(argument: suspend CostCategoryRuleRuleNotCostCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleNotCostCategoryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("gypkbjdjxxedrfui")
    public suspend fun dimension(`value`: CostCategoryRuleRuleNotDimensionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("ipsnxsqemlnliwch")
    public suspend fun dimension(argument: suspend CostCategoryRuleRuleNotDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleNotDimensionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dimension = mapped
    }

    /**
     * @param value Return results that match both `Dimension` object.
     */
    @JvmName("bfkfwapdbrhmmsdy")
    public suspend fun not(`value`: CostCategoryRuleRuleNotNotArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.not = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` object.
     */
    @JvmName("nncirijxbcrqpkpy")
    public suspend fun not(argument: suspend CostCategoryRuleRuleNotNotArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleNotNotArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.not = mapped
    }

    /**
     * @param value Return results that match both `Dimension` object.
     */
    @JvmName("sumlngfuyatuqypo")
    public suspend fun ors(`value`: List<CostCategoryRuleRuleNotOrArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ors = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` object.
     */
    @JvmName("pivqwvufsrbuyyqx")
    public suspend fun ors(argument: List<suspend CostCategoryRuleRuleNotOrArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CostCategoryRuleRuleNotOrArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ors = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` object.
     */
    @JvmName("gawnleqddkmawlow")
    public suspend fun ors(vararg argument: suspend CostCategoryRuleRuleNotOrArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CostCategoryRuleRuleNotOrArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ors = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` object.
     */
    @JvmName("eviyafpecbvnumtg")
    public suspend fun ors(argument: suspend CostCategoryRuleRuleNotOrArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CostCategoryRuleRuleNotOrArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ors = mapped
    }

    /**
     * @param values Return results that match both `Dimension` object.
     */
    @JvmName("vbuxcrgomgeekdpp")
    public suspend fun ors(vararg values: CostCategoryRuleRuleNotOrArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ors = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kghchxhkdrcuspwn")
    public suspend fun tags(`value`: CostCategoryRuleRuleNotTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jccxxgdopkxuvdvt")
    public suspend fun tags(argument: suspend CostCategoryRuleRuleNotTagsArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleNotTagsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): CostCategoryRuleRuleNotArgs = CostCategoryRuleRuleNotArgs(
        ands = ands,
        costCategory = costCategory,
        dimension = dimension,
        not = not,
        ors = ors,
        tags = tags,
    )
}
