@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotNotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CostCategoryRuleRuleNotNotArgs(
    public val costCategory: Output<CostCategoryRuleRuleNotNotCostCategoryArgs>? = null,
    public val dimension: Output<CostCategoryRuleRuleNotNotDimensionArgs>? = null,
    public val tags: Output<CostCategoryRuleRuleNotNotTagsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotNotArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotNotArgs =
        com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotNotArgs.builder()
            .costCategory(costCategory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CostCategoryRuleRuleNotNotArgs].
 */
@PulumiTagMarker
public class CostCategoryRuleRuleNotNotArgsBuilder internal constructor() {
    private var costCategory: Output<CostCategoryRuleRuleNotNotCostCategoryArgs>? = null

    private var dimension: Output<CostCategoryRuleRuleNotNotDimensionArgs>? = null

    private var tags: Output<CostCategoryRuleRuleNotNotTagsArgs>? = null

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("bnshwrthvrgoluuo")
    public suspend fun costCategory(`value`: Output<CostCategoryRuleRuleNotNotCostCategoryArgs>) {
        this.costCategory = value
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("accgloxdtscnbikj")
    public suspend fun dimension(`value`: Output<CostCategoryRuleRuleNotNotDimensionArgs>) {
        this.dimension = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bojcfupeenxfuksl")
    public suspend fun tags(`value`: Output<CostCategoryRuleRuleNotNotTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("xxpotuyknhyopqag")
    public suspend fun costCategory(`value`: CostCategoryRuleRuleNotNotCostCategoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("jlggfnqpbiriwfrp")
    public suspend fun costCategory(argument: suspend CostCategoryRuleRuleNotNotCostCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleNotNotCostCategoryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("pdguskscvywrccmi")
    public suspend fun dimension(`value`: CostCategoryRuleRuleNotNotDimensionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("pmmhypiwdamawiyc")
    public suspend fun dimension(argument: suspend CostCategoryRuleRuleNotNotDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleNotNotDimensionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dimension = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lacpmeiamwecsycf")
    public suspend fun tags(`value`: CostCategoryRuleRuleNotNotTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wtxmihyrpwlwoynu")
    public suspend fun tags(argument: suspend CostCategoryRuleRuleNotNotTagsArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleNotNotTagsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): CostCategoryRuleRuleNotNotArgs = CostCategoryRuleRuleNotNotArgs(
        costCategory = costCategory,
        dimension = dimension,
        tags = tags,
    )
}
