@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotOrArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CostCategoryRuleRuleNotOrArgs(
    public val costCategory: Output<CostCategoryRuleRuleNotOrCostCategoryArgs>? = null,
    public val dimension: Output<CostCategoryRuleRuleNotOrDimensionArgs>? = null,
    public val tags: Output<CostCategoryRuleRuleNotOrTagsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotOrArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotOrArgs =
        com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotOrArgs.builder()
            .costCategory(costCategory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CostCategoryRuleRuleNotOrArgs].
 */
@PulumiTagMarker
public class CostCategoryRuleRuleNotOrArgsBuilder internal constructor() {
    private var costCategory: Output<CostCategoryRuleRuleNotOrCostCategoryArgs>? = null

    private var dimension: Output<CostCategoryRuleRuleNotOrDimensionArgs>? = null

    private var tags: Output<CostCategoryRuleRuleNotOrTagsArgs>? = null

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("ojuetmrovrdyultg")
    public suspend fun costCategory(`value`: Output<CostCategoryRuleRuleNotOrCostCategoryArgs>) {
        this.costCategory = value
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("bhihdsieoqfuseyx")
    public suspend fun dimension(`value`: Output<CostCategoryRuleRuleNotOrDimensionArgs>) {
        this.dimension = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hivhjxopbowgjipe")
    public suspend fun tags(`value`: Output<CostCategoryRuleRuleNotOrTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("gvxifdrlrplmenmc")
    public suspend fun costCategory(`value`: CostCategoryRuleRuleNotOrCostCategoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("rycoeyeoylbqxpew")
    public suspend fun costCategory(argument: suspend CostCategoryRuleRuleNotOrCostCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleNotOrCostCategoryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("rqesnpbmcbtkctrx")
    public suspend fun dimension(`value`: CostCategoryRuleRuleNotOrDimensionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("qrmddeqpbwaovkiq")
    public suspend fun dimension(argument: suspend CostCategoryRuleRuleNotOrDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleNotOrDimensionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dimension = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ruyybxakbirvuksu")
    public suspend fun tags(`value`: CostCategoryRuleRuleNotOrTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kctotuvlkmdpjmpe")
    public suspend fun tags(argument: suspend CostCategoryRuleRuleNotOrTagsArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleNotOrTagsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): CostCategoryRuleRuleNotOrArgs = CostCategoryRuleRuleNotOrArgs(
        costCategory = costCategory,
        dimension = dimension,
        tags = tags,
    )
}
