@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotOrCostCategoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property key Unique name of the Cost Category.
 * @property matchOptions Match options that you can use to filter your results. MatchOptions is only applicable for actions related to cost category. The default values for MatchOptions is `EQUALS` and `CASE_SENSITIVE`. Valid values are: `EQUALS`,  `ABSENT`, `STARTS_WITH`, `ENDS_WITH`, `CONTAINS`, `CASE_SENSITIVE`, `CASE_INSENSITIVE`.
 * @property values Specific value of the Cost Category.
 */
public data class CostCategoryRuleRuleNotOrCostCategoryArgs(
    public val key: Output<String>? = null,
    public val matchOptions: Output<List<String>>? = null,
    public val values: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotOrCostCategoryArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotOrCostCategoryArgs =
        com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleNotOrCostCategoryArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .matchOptions(matchOptions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [CostCategoryRuleRuleNotOrCostCategoryArgs].
 */
@PulumiTagMarker
public class CostCategoryRuleRuleNotOrCostCategoryArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var matchOptions: Output<List<String>>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value Unique name of the Cost Category.
     */
    @JvmName("iecnyqhqspamlxwg")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Match options that you can use to filter your results. MatchOptions is only applicable for actions related to cost category. The default values for MatchOptions is `EQUALS` and `CASE_SENSITIVE`. Valid values are: `EQUALS`,  `ABSENT`, `STARTS_WITH`, `ENDS_WITH`, `CONTAINS`, `CASE_SENSITIVE`, `CASE_INSENSITIVE`.
     */
    @JvmName("cpcklhdiaxxylykf")
    public suspend fun matchOptions(`value`: Output<List<String>>) {
        this.matchOptions = value
    }

    @JvmName("qfrvcmawiqietann")
    public suspend fun matchOptions(vararg values: Output<String>) {
        this.matchOptions = Output.all(values.asList())
    }

    /**
     * @param values Match options that you can use to filter your results. MatchOptions is only applicable for actions related to cost category. The default values for MatchOptions is `EQUALS` and `CASE_SENSITIVE`. Valid values are: `EQUALS`,  `ABSENT`, `STARTS_WITH`, `ENDS_WITH`, `CONTAINS`, `CASE_SENSITIVE`, `CASE_INSENSITIVE`.
     */
    @JvmName("mjglirokrrrvyvep")
    public suspend fun matchOptions(values: List<Output<String>>) {
        this.matchOptions = Output.all(values)
    }

    /**
     * @param value Specific value of the Cost Category.
     */
    @JvmName("ojaeuthdgcitigev")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("laldmaiqnlkkvlnu")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values Specific value of the Cost Category.
     */
    @JvmName("wfggdeumrtqoubmb")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value Unique name of the Cost Category.
     */
    @JvmName("rkgkaqvcxokfsxcy")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Match options that you can use to filter your results. MatchOptions is only applicable for actions related to cost category. The default values for MatchOptions is `EQUALS` and `CASE_SENSITIVE`. Valid values are: `EQUALS`,  `ABSENT`, `STARTS_WITH`, `ENDS_WITH`, `CONTAINS`, `CASE_SENSITIVE`, `CASE_INSENSITIVE`.
     */
    @JvmName("cchwtsjspkgicnyg")
    public suspend fun matchOptions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchOptions = mapped
    }

    /**
     * @param values Match options that you can use to filter your results. MatchOptions is only applicable for actions related to cost category. The default values for MatchOptions is `EQUALS` and `CASE_SENSITIVE`. Valid values are: `EQUALS`,  `ABSENT`, `STARTS_WITH`, `ENDS_WITH`, `CONTAINS`, `CASE_SENSITIVE`, `CASE_INSENSITIVE`.
     */
    @JvmName("fbojwknybokianbn")
    public suspend fun matchOptions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchOptions = mapped
    }

    /**
     * @param value Specific value of the Cost Category.
     */
    @JvmName("budjdtshdrfyafdo")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values Specific value of the Cost Category.
     */
    @JvmName("lusjsomoanvvojle")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): CostCategoryRuleRuleNotOrCostCategoryArgs =
        CostCategoryRuleRuleNotOrCostCategoryArgs(
            key = key,
            matchOptions = matchOptions,
            values = values,
        )
}
