@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleOrAndArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CostCategoryRuleRuleOrAndArgs(
    public val costCategory: Output<CostCategoryRuleRuleOrAndCostCategoryArgs>? = null,
    public val dimension: Output<CostCategoryRuleRuleOrAndDimensionArgs>? = null,
    public val tags: Output<CostCategoryRuleRuleOrAndTagsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleOrAndArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleOrAndArgs =
        com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleOrAndArgs.builder()
            .costCategory(costCategory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CostCategoryRuleRuleOrAndArgs].
 */
@PulumiTagMarker
public class CostCategoryRuleRuleOrAndArgsBuilder internal constructor() {
    private var costCategory: Output<CostCategoryRuleRuleOrAndCostCategoryArgs>? = null

    private var dimension: Output<CostCategoryRuleRuleOrAndDimensionArgs>? = null

    private var tags: Output<CostCategoryRuleRuleOrAndTagsArgs>? = null

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("nwyfxueuppsckaob")
    public suspend fun costCategory(`value`: Output<CostCategoryRuleRuleOrAndCostCategoryArgs>) {
        this.costCategory = value
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("pndjpfnvgvabogbr")
    public suspend fun dimension(`value`: Output<CostCategoryRuleRuleOrAndDimensionArgs>) {
        this.dimension = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yvniyriaqmerlvot")
    public suspend fun tags(`value`: Output<CostCategoryRuleRuleOrAndTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("bewfghnqwrebjceu")
    public suspend fun costCategory(`value`: CostCategoryRuleRuleOrAndCostCategoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("jovkfhwuasotcjcn")
    public suspend fun costCategory(argument: suspend CostCategoryRuleRuleOrAndCostCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleOrAndCostCategoryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("rutwntktgxvjepeh")
    public suspend fun dimension(`value`: CostCategoryRuleRuleOrAndDimensionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("nphcmgutmdribikh")
    public suspend fun dimension(argument: suspend CostCategoryRuleRuleOrAndDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleOrAndDimensionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dimension = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("keiupblsdsfgqbiw")
    public suspend fun tags(`value`: CostCategoryRuleRuleOrAndTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("htyqvkcpucbqpblr")
    public suspend fun tags(argument: suspend CostCategoryRuleRuleOrAndTagsArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleOrAndTagsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): CostCategoryRuleRuleOrAndArgs = CostCategoryRuleRuleOrAndArgs(
        costCategory = costCategory,
        dimension = dimension,
        tags = tags,
    )
}
