@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleOrArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property ands Return results that match both `Dimension` objects.
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property not Return results that match both `Dimension` object.
 * @property ors Return results that match both `Dimension` object.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CostCategoryRuleRuleOrArgs(
    public val ands: Output<List<CostCategoryRuleRuleOrAndArgs>>? = null,
    public val costCategory: Output<CostCategoryRuleRuleOrCostCategoryArgs>? = null,
    public val dimension: Output<CostCategoryRuleRuleOrDimensionArgs>? = null,
    public val not: Output<CostCategoryRuleRuleOrNotArgs>? = null,
    public val ors: Output<List<CostCategoryRuleRuleOrOrArgs>>? = null,
    public val tags: Output<CostCategoryRuleRuleOrTagsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleOrArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleOrArgs =
        com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleOrArgs.builder()
            .ands(ands?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .costCategory(costCategory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .not(not?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ors(ors?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CostCategoryRuleRuleOrArgs].
 */
@PulumiTagMarker
public class CostCategoryRuleRuleOrArgsBuilder internal constructor() {
    private var ands: Output<List<CostCategoryRuleRuleOrAndArgs>>? = null

    private var costCategory: Output<CostCategoryRuleRuleOrCostCategoryArgs>? = null

    private var dimension: Output<CostCategoryRuleRuleOrDimensionArgs>? = null

    private var not: Output<CostCategoryRuleRuleOrNotArgs>? = null

    private var ors: Output<List<CostCategoryRuleRuleOrOrArgs>>? = null

    private var tags: Output<CostCategoryRuleRuleOrTagsArgs>? = null

    /**
     * @param value Return results that match both `Dimension` objects.
     */
    @JvmName("vyqsmsymbdbdtyks")
    public suspend fun ands(`value`: Output<List<CostCategoryRuleRuleOrAndArgs>>) {
        this.ands = value
    }

    @JvmName("qwiotdenrmafmyrs")
    public suspend fun ands(vararg values: Output<CostCategoryRuleRuleOrAndArgs>) {
        this.ands = Output.all(values.asList())
    }

    /**
     * @param values Return results that match both `Dimension` objects.
     */
    @JvmName("nqiyynsvaoetlicn")
    public suspend fun ands(values: List<Output<CostCategoryRuleRuleOrAndArgs>>) {
        this.ands = Output.all(values)
    }

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("wpexgslkdduyojjh")
    public suspend fun costCategory(`value`: Output<CostCategoryRuleRuleOrCostCategoryArgs>) {
        this.costCategory = value
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("mmhifodfakkensrc")
    public suspend fun dimension(`value`: Output<CostCategoryRuleRuleOrDimensionArgs>) {
        this.dimension = value
    }

    /**
     * @param value Return results that match both `Dimension` object.
     */
    @JvmName("icjvegrkkufmwtid")
    public suspend fun not(`value`: Output<CostCategoryRuleRuleOrNotArgs>) {
        this.not = value
    }

    /**
     * @param value Return results that match both `Dimension` object.
     */
    @JvmName("cwvgiuthjnmyiovf")
    public suspend fun ors(`value`: Output<List<CostCategoryRuleRuleOrOrArgs>>) {
        this.ors = value
    }

    @JvmName("tbvohhouxlhfnbrv")
    public suspend fun ors(vararg values: Output<CostCategoryRuleRuleOrOrArgs>) {
        this.ors = Output.all(values.asList())
    }

    /**
     * @param values Return results that match both `Dimension` object.
     */
    @JvmName("vdnqcdmkeexdmlcx")
    public suspend fun ors(values: List<Output<CostCategoryRuleRuleOrOrArgs>>) {
        this.ors = Output.all(values)
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ddxpglfbhuuuanpm")
    public suspend fun tags(`value`: Output<CostCategoryRuleRuleOrTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value Return results that match both `Dimension` objects.
     */
    @JvmName("nwkranhkykxpwica")
    public suspend fun ands(`value`: List<CostCategoryRuleRuleOrAndArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ands = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` objects.
     */
    @JvmName("kqhsfxtmclgbomuv")
    public suspend fun ands(argument: List<suspend CostCategoryRuleRuleOrAndArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CostCategoryRuleRuleOrAndArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` objects.
     */
    @JvmName("fdsgmiqhjjuhykrg")
    public suspend fun ands(vararg argument: suspend CostCategoryRuleRuleOrAndArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CostCategoryRuleRuleOrAndArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` objects.
     */
    @JvmName("jlwlnvtqagifdnop")
    public suspend fun ands(argument: suspend CostCategoryRuleRuleOrAndArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CostCategoryRuleRuleOrAndArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ands = mapped
    }

    /**
     * @param values Return results that match both `Dimension` objects.
     */
    @JvmName("fxhfieqpiaqxyloh")
    public suspend fun ands(vararg values: CostCategoryRuleRuleOrAndArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ands = mapped
    }

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("esrtqsdenlhqiwxq")
    public suspend fun costCategory(`value`: CostCategoryRuleRuleOrCostCategoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("deqymbvqxroylhju")
    public suspend fun costCategory(argument: suspend CostCategoryRuleRuleOrCostCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleOrCostCategoryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("dguigcaechtjruxk")
    public suspend fun dimension(`value`: CostCategoryRuleRuleOrDimensionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("jboajemgmjpgdvqs")
    public suspend fun dimension(argument: suspend CostCategoryRuleRuleOrDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleOrDimensionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dimension = mapped
    }

    /**
     * @param value Return results that match both `Dimension` object.
     */
    @JvmName("bqyiciwfdjwnudyo")
    public suspend fun not(`value`: CostCategoryRuleRuleOrNotArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.not = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` object.
     */
    @JvmName("siwwhpludgfhyyrn")
    public suspend fun not(argument: suspend CostCategoryRuleRuleOrNotArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleOrNotArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.not = mapped
    }

    /**
     * @param value Return results that match both `Dimension` object.
     */
    @JvmName("gvsbmtfwpxrvkxqb")
    public suspend fun ors(`value`: List<CostCategoryRuleRuleOrOrArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ors = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` object.
     */
    @JvmName("tcqiuxayheubwgse")
    public suspend fun ors(argument: List<suspend CostCategoryRuleRuleOrOrArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CostCategoryRuleRuleOrOrArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ors = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` object.
     */
    @JvmName("uwoutsflgkqaiocj")
    public suspend fun ors(vararg argument: suspend CostCategoryRuleRuleOrOrArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CostCategoryRuleRuleOrOrArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ors = mapped
    }

    /**
     * @param argument Return results that match both `Dimension` object.
     */
    @JvmName("bdvffbylrwywuqft")
    public suspend fun ors(argument: suspend CostCategoryRuleRuleOrOrArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CostCategoryRuleRuleOrOrArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ors = mapped
    }

    /**
     * @param values Return results that match both `Dimension` object.
     */
    @JvmName("ihkinviolppjclqg")
    public suspend fun ors(vararg values: CostCategoryRuleRuleOrOrArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ors = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dshjqotoxrkcwvfs")
    public suspend fun tags(`value`: CostCategoryRuleRuleOrTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tnognydxllrsubvk")
    public suspend fun tags(argument: suspend CostCategoryRuleRuleOrTagsArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleOrTagsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): CostCategoryRuleRuleOrArgs = CostCategoryRuleRuleOrArgs(
        ands = ands,
        costCategory = costCategory,
        dimension = dimension,
        not = not,
        ors = ors,
        tags = tags,
    )
}
