@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleOrNotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CostCategoryRuleRuleOrNotArgs(
    public val costCategory: Output<CostCategoryRuleRuleOrNotCostCategoryArgs>? = null,
    public val dimension: Output<CostCategoryRuleRuleOrNotDimensionArgs>? = null,
    public val tags: Output<CostCategoryRuleRuleOrNotTagsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleOrNotArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleOrNotArgs =
        com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleOrNotArgs.builder()
            .costCategory(costCategory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CostCategoryRuleRuleOrNotArgs].
 */
@PulumiTagMarker
public class CostCategoryRuleRuleOrNotArgsBuilder internal constructor() {
    private var costCategory: Output<CostCategoryRuleRuleOrNotCostCategoryArgs>? = null

    private var dimension: Output<CostCategoryRuleRuleOrNotDimensionArgs>? = null

    private var tags: Output<CostCategoryRuleRuleOrNotTagsArgs>? = null

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("jtkhvyouwfxllkep")
    public suspend fun costCategory(`value`: Output<CostCategoryRuleRuleOrNotCostCategoryArgs>) {
        this.costCategory = value
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("suwguypgtpdrsfmg")
    public suspend fun dimension(`value`: Output<CostCategoryRuleRuleOrNotDimensionArgs>) {
        this.dimension = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yrorkqiejvfrwuwi")
    public suspend fun tags(`value`: Output<CostCategoryRuleRuleOrNotTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("tjewpdufbdckinqt")
    public suspend fun costCategory(`value`: CostCategoryRuleRuleOrNotCostCategoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("strtuaojsilfphbs")
    public suspend fun costCategory(argument: suspend CostCategoryRuleRuleOrNotCostCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleOrNotCostCategoryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("qftjkdtrtsleyqti")
    public suspend fun dimension(`value`: CostCategoryRuleRuleOrNotDimensionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("abtdkvtehcsfjerh")
    public suspend fun dimension(argument: suspend CostCategoryRuleRuleOrNotDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleOrNotDimensionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dimension = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rqbrmribvkajitwx")
    public suspend fun tags(`value`: CostCategoryRuleRuleOrNotTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ndbnmjkibybjgxtv")
    public suspend fun tags(argument: suspend CostCategoryRuleRuleOrNotTagsArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleOrNotTagsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): CostCategoryRuleRuleOrNotArgs = CostCategoryRuleRuleOrNotArgs(
        costCategory = costCategory,
        dimension = dimension,
        tags = tags,
    )
}
