@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleOrOrArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CostCategoryRuleRuleOrOrArgs(
    public val costCategory: Output<CostCategoryRuleRuleOrOrCostCategoryArgs>? = null,
    public val dimension: Output<CostCategoryRuleRuleOrOrDimensionArgs>? = null,
    public val tags: Output<CostCategoryRuleRuleOrOrTagsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleOrOrArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleOrOrArgs =
        com.pulumi.aws.costexplorer.inputs.CostCategoryRuleRuleOrOrArgs.builder()
            .costCategory(costCategory?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CostCategoryRuleRuleOrOrArgs].
 */
@PulumiTagMarker
public class CostCategoryRuleRuleOrOrArgsBuilder internal constructor() {
    private var costCategory: Output<CostCategoryRuleRuleOrOrCostCategoryArgs>? = null

    private var dimension: Output<CostCategoryRuleRuleOrOrDimensionArgs>? = null

    private var tags: Output<CostCategoryRuleRuleOrOrTagsArgs>? = null

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("ahvgggmolerebupe")
    public suspend fun costCategory(`value`: Output<CostCategoryRuleRuleOrOrCostCategoryArgs>) {
        this.costCategory = value
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("wpfuafwqpiowxgfh")
    public suspend fun dimension(`value`: Output<CostCategoryRuleRuleOrOrDimensionArgs>) {
        this.dimension = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xnjkimubvwyoxavp")
    public suspend fun tags(`value`: Output<CostCategoryRuleRuleOrOrTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("ykrmtcxkqowslcvc")
    public suspend fun costCategory(`value`: CostCategoryRuleRuleOrOrCostCategoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on `CostCategory` values. See below.
     */
    @JvmName("omxttrqmosceuvhx")
    public suspend fun costCategory(argument: suspend CostCategoryRuleRuleOrOrCostCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleOrOrCostCategoryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("jwpxvokmxctlscwr")
    public suspend fun dimension(`value`: CostCategoryRuleRuleOrOrDimensionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific `Dimension` to use for `Expression`. See below.
     */
    @JvmName("bhxcaupygfhahfyj")
    public suspend fun dimension(argument: suspend CostCategoryRuleRuleOrOrDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleOrOrDimensionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dimension = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vckwdpearopeqpxe")
    public suspend fun tags(`value`: CostCategoryRuleRuleOrOrTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("assyomqhtuupbfmw")
    public suspend fun tags(argument: suspend CostCategoryRuleRuleOrOrTagsArgsBuilder.() -> Unit) {
        val toBeMapped = CostCategoryRuleRuleOrOrTagsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): CostCategoryRuleRuleOrOrArgs = CostCategoryRuleRuleOrOrArgs(
        costCategory = costCategory,
        dimension = dimension,
        tags = tags,
    )
}
