@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.CostCategorySplitChargeRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property method Method that's used to define how to split your source costs across your targets. Valid values are `FIXED`, `PROPORTIONAL`, `EVEN`
 * @property parameters Configuration block for the parameters for a split charge method. This is only required for the `FIXED` method. See below.
 * @property source Cost Category value that you want to split.
 * @property targets Cost Category values that you want to split costs across. These values can't be used as a source in other split charge rules.
 */
public data class CostCategorySplitChargeRuleArgs(
    public val method: Output<String>,
    public val parameters: Output<List<CostCategorySplitChargeRuleParameterArgs>>? = null,
    public val source: Output<String>,
    public val targets: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.CostCategorySplitChargeRuleArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.CostCategorySplitChargeRuleArgs =
        com.pulumi.aws.costexplorer.inputs.CostCategorySplitChargeRuleArgs.builder()
            .method(method.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .source(source.applyValue({ args0 -> args0 }))
            .targets(targets.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [CostCategorySplitChargeRuleArgs].
 */
@PulumiTagMarker
public class CostCategorySplitChargeRuleArgsBuilder internal constructor() {
    private var method: Output<String>? = null

    private var parameters: Output<List<CostCategorySplitChargeRuleParameterArgs>>? = null

    private var source: Output<String>? = null

    private var targets: Output<List<String>>? = null

    /**
     * @param value Method that's used to define how to split your source costs across your targets. Valid values are `FIXED`, `PROPORTIONAL`, `EVEN`
     */
    @JvmName("jrtuxeinricandnj")
    public suspend fun method(`value`: Output<String>) {
        this.method = value
    }

    /**
     * @param value Configuration block for the parameters for a split charge method. This is only required for the `FIXED` method. See below.
     */
    @JvmName("ofywmkqbenqtpgdv")
    public suspend fun parameters(`value`: Output<List<CostCategorySplitChargeRuleParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("ikdvoragoghpkoat")
    public suspend fun parameters(vararg values: Output<CostCategorySplitChargeRuleParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for the parameters for a split charge method. This is only required for the `FIXED` method. See below.
     */
    @JvmName("ypwbitpubohvjvef")
    public suspend fun parameters(values: List<Output<CostCategorySplitChargeRuleParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value Cost Category value that you want to split.
     */
    @JvmName("kufgsyxfmdcjdgoa")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value Cost Category values that you want to split costs across. These values can't be used as a source in other split charge rules.
     */
    @JvmName("hutqlffxqwepnpsl")
    public suspend fun targets(`value`: Output<List<String>>) {
        this.targets = value
    }

    @JvmName("rtlwcawemfawaamr")
    public suspend fun targets(vararg values: Output<String>) {
        this.targets = Output.all(values.asList())
    }

    /**
     * @param values Cost Category values that you want to split costs across. These values can't be used as a source in other split charge rules.
     */
    @JvmName("avjepnknisigjexi")
    public suspend fun targets(values: List<Output<String>>) {
        this.targets = Output.all(values)
    }

    /**
     * @param value Method that's used to define how to split your source costs across your targets. Valid values are `FIXED`, `PROPORTIONAL`, `EVEN`
     */
    @JvmName("nwfaluxgoladurjo")
    public suspend fun method(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value Configuration block for the parameters for a split charge method. This is only required for the `FIXED` method. See below.
     */
    @JvmName("stswbfdfctgfborl")
    public suspend fun parameters(`value`: List<CostCategorySplitChargeRuleParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Configuration block for the parameters for a split charge method. This is only required for the `FIXED` method. See below.
     */
    @JvmName("erhruirgldelupwv")
    public suspend fun parameters(argument: List<suspend CostCategorySplitChargeRuleParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CostCategorySplitChargeRuleParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Configuration block for the parameters for a split charge method. This is only required for the `FIXED` method. See below.
     */
    @JvmName("kpwfrujejwmimhxf")
    public suspend fun parameters(vararg argument: suspend CostCategorySplitChargeRuleParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CostCategorySplitChargeRuleParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Configuration block for the parameters for a split charge method. This is only required for the `FIXED` method. See below.
     */
    @JvmName("eqirbkgbipcyejky")
    public suspend fun parameters(argument: suspend CostCategorySplitChargeRuleParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CostCategorySplitChargeRuleParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Configuration block for the parameters for a split charge method. This is only required for the `FIXED` method. See below.
     */
    @JvmName("ykcuuiiqxfhjccug")
    public suspend fun parameters(vararg values: CostCategorySplitChargeRuleParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Cost Category value that you want to split.
     */
    @JvmName("ddfxkqlxcjiaodcr")
    public suspend fun source(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Cost Category values that you want to split costs across. These values can't be used as a source in other split charge rules.
     */
    @JvmName("yehttautkatuyoxg")
    public suspend fun targets(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param values Cost Category values that you want to split costs across. These values can't be used as a source in other split charge rules.
     */
    @JvmName("xehgaewscecgcufc")
    public suspend fun targets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    internal fun build(): CostCategorySplitChargeRuleArgs = CostCategorySplitChargeRuleArgs(
        method = method ?: throw PulumiNullFieldException("method"),
        parameters = parameters,
        source = source ?: throw PulumiNullFieldException("source"),
        targets = targets ?: throw PulumiNullFieldException("targets"),
    )
}
